/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.kmeans.KmeansSampler;
import org.neo4j.gds.kmeans.KmeansStreamConfig;

public final class KmeansStreamConfigImpl
implements KmeansStreamConfig {
    private int maxIterations;
    private int k;
    private double deltaThreshold;
    private int numberOfRestarts;
    private boolean computeSilhouette;
    private String nodeProperty;
    private KmeansSampler.SamplerType initialSampler;
    private List<List<Double>> seedCentroids;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    private Optional<Long> randomSeed;

    public KmeansStreamConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.maxIterations = config.getInt("maxIterations", KmeansStreamConfig.super.maxIterations());
            CypherMapAccess.validateIntegerRange((String)"maxIterations", (int)this.maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.k = config.getInt("k", KmeansStreamConfig.super.k());
            CypherMapAccess.validateIntegerRange((String)"k", (int)this.k, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.deltaThreshold = config.getDouble("deltaThreshold", KmeansStreamConfig.super.deltaThreshold());
            CypherMapAccess.validateDoubleRange((String)"deltaThreshold", (double)this.deltaThreshold, (double)0.0, (double)1.0, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.numberOfRestarts = config.getInt("numberOfRestarts", KmeansStreamConfig.super.numberOfRestarts());
            CypherMapAccess.validateIntegerRange((String)"numberOfRestarts", (int)this.numberOfRestarts, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.computeSilhouette = config.getBool("computeSilhouette", KmeansStreamConfig.super.computeSilhouette());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeProperty = (String)CypherMapAccess.failOnNull((String)"nodeProperty", (Object)config.requireString("nodeProperty"));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.initialSampler = (KmeansSampler.SamplerType)((Object)CypherMapAccess.failOnNull((String)"initialSampler", (Object)((Object)KmeansSampler.SamplerType.parse(config.getChecked("initialSampler", (Object)KmeansStreamConfig.super.initialSampler(), Object.class)))));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.seedCentroids = (List)CypherMapAccess.failOnNull((String)"seedCentroids", (Object)((List)config.getChecked("seedCentroids", KmeansStreamConfig.super.seedCentroids(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)KmeansStreamConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)KmeansStreamConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", KmeansStreamConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", KmeansStreamConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", KmeansStreamConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)KmeansStreamConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.randomSeed = (Optional)CypherMapAccess.failOnNull((String)"randomSeed", (Object)config.getOptional("randomSeed", Long.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int k() {
        return this.k;
    }

    @Override
    public double deltaThreshold() {
        return this.deltaThreshold;
    }

    @Override
    public int numberOfRestarts() {
        return this.numberOfRestarts;
    }

    @Override
    public boolean computeSilhouette() {
        return this.computeSilhouette;
    }

    @Override
    public String nodeProperty() {
        return this.nodeProperty;
    }

    @Override
    public KmeansSampler.SamplerType initialSampler() {
        return this.initialSampler;
    }

    @Override
    public List<List<Double>> seedCentroids() {
        return this.seedCentroids;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.nodePropertyTypeValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("maxIterations", "k", "deltaThreshold", "numberOfRestarts", "computeSilhouette", "nodeProperty", "initialSampler", "seedCentroids", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "randomSeed");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("maxIterations", this.maxIterations());
        map.put("k", this.k());
        map.put("deltaThreshold", this.deltaThreshold());
        map.put("numberOfRestarts", this.numberOfRestarts());
        map.put("computeSilhouette", this.computeSilhouette());
        map.put("nodeProperty", this.nodeProperty());
        map.put("initialSampler", KmeansSampler.SamplerType.toString(this.initialSampler()));
        map.put("seedCentroids", this.seedCentroids());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        this.randomSeed().ifPresent(randomSeed -> map.put("randomSeed", randomSeed));
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    public Optional<Long> randomSeed() {
        return this.randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(KmeansStreamConfig baseConfig) {
            Builder builder = new Builder();
            builder.maxIterations(baseConfig.maxIterations());
            builder.k(baseConfig.k());
            builder.deltaThreshold(baseConfig.deltaThreshold());
            builder.numberOfRestarts(baseConfig.numberOfRestarts());
            builder.computeSilhouette(baseConfig.computeSilhouette());
            builder.nodeProperty(baseConfig.nodeProperty());
            builder.initialSampler((Object)baseConfig.initialSampler());
            builder.seedCentroids(baseConfig.seedCentroids());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.randomSeed(baseConfig.randomSeed());
            return builder;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder k(int k) {
            this.config.put("k", k);
            return this;
        }

        public Builder deltaThreshold(double deltaThreshold) {
            this.config.put("deltaThreshold", deltaThreshold);
            return this;
        }

        public Builder numberOfRestarts(int numberOfRestarts) {
            this.config.put("numberOfRestarts", numberOfRestarts);
            return this;
        }

        public Builder computeSilhouette(boolean computeSilhouette) {
            this.config.put("computeSilhouette", computeSilhouette);
            return this;
        }

        public Builder nodeProperty(String nodeProperty) {
            this.config.put("nodeProperty", nodeProperty);
            return this;
        }

        public Builder initialSampler(Object initialSampler) {
            this.config.put("initialSampler", initialSampler);
            return this;
        }

        public Builder seedCentroids(List<List<Double>> seedCentroids) {
            this.config.put("seedCentroids", seedCentroids);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder randomSeed(Long randomSeed) {
            this.config.put("randomSeed", randomSeed);
            return this;
        }

        public Builder randomSeed(Optional<Long> randomSeed) {
            randomSeed.ifPresent(actualrandomSeed -> this.config.put("randomSeed", actualrandomSeed));
            return this;
        }

        public KmeansStreamConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new KmeansStreamConfigImpl((CypherMapAccess)config);
        }
    }
}

