/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SplittableRandom;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.ClusterManager;
import org.neo4j.gds.kmeans.KmeansSampler;

public class KmeansUniformSampler
extends KmeansSampler {
    private final ProgressTracker progressTracker;

    @Override
    public void performInitialSampling() {
        List<Long> initialCentroids = this.sampleClusters();
        this.clusterManager.initializeCentroids(initialCentroids);
    }

    public KmeansUniformSampler(SplittableRandom random, ClusterManager clusterManager, long nodeCount, int k, ProgressTracker progressTracker) {
        super(random, clusterManager, nodeCount, k);
        this.progressTracker = progressTracker;
    }

    private List<Long> sampleClusters() {
        HashSet<Long> sampled = new HashSet<Long>();
        while (sampled.size() < this.k) {
            long nodeId = this.random.nextLong(this.nodeCount);
            if (sampled.contains(nodeId)) continue;
            sampled.add(nodeId);
            this.progressTracker.logProgress(1L);
        }
        return new ArrayList<Long>(sampled);
    }
}

