/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.kmeans;

import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeIntArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.kmeans.DoubleSilhouetteTask;
import org.neo4j.gds.kmeans.FloatSilhouetteTask;

public abstract class SilhouetteTask
implements Runnable {
    final HugeIntArray communities;
    final HugeDoubleArray silhouette;
    final double[] clusterDistance;
    final ProgressTracker progressTracker;
    final Partition partition;
    final long[] nodesInCluster;
    final int k;
    final int dimensions;
    double averageSilhouette;
    final NodePropertyValues nodePropertyValues;

    abstract double distance(long var1, long var3);

    SilhouetteTask(NodePropertyValues nodePropertyValues, HugeIntArray communities, HugeDoubleArray silhouette, int k, int dimensions, long[] nodesInCluster, Partition partition, ProgressTracker progressTracker) {
        this.nodePropertyValues = nodePropertyValues;
        this.communities = communities;
        this.k = k;
        this.dimensions = dimensions;
        this.partition = partition;
        this.progressTracker = progressTracker;
        this.silhouette = silhouette;
        this.nodesInCluster = nodesInCluster;
        this.clusterDistance = new double[k];
        this.averageSilhouette = 0.0;
    }

    @Override
    public void run() {
        long nodeCount = this.communities.size();
        long startNode = this.partition.startNode();
        long endNode = startNode + this.partition.nodeCount();
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            int clusterId = this.communities.get(nodeId);
            if (this.nodesInCluster[clusterId] == 1L) {
                this.silhouette.set(nodeId, 0.0);
                continue;
            }
            for (int cluster = 0; cluster < this.k; ++cluster) {
                this.clusterDistance[cluster] = 0.0;
            }
            for (long oNodeId = 0L; oNodeId < nodeCount; ++oNodeId) {
                int oClusterId;
                if (oNodeId == nodeId) continue;
                double euclidean = this.distance(nodeId, oNodeId);
                int n = oClusterId = this.communities.get(oNodeId);
                this.clusterDistance[n] = this.clusterDistance[n] + euclidean;
            }
            double bi = Double.MAX_VALUE;
            for (int cluster = 0; cluster < this.k; ++cluster) {
                if (clusterId == cluster) continue;
                bi = Math.min(bi, this.clusterDistance[cluster] / (double)this.nodesInCluster[cluster]);
            }
            double ai = this.clusterDistance[clusterId] / (double)(this.nodesInCluster[clusterId] - 1L);
            double nodeSilhouette = (bi - ai) / Math.max(ai, bi);
            this.silhouette.set(nodeId, nodeSilhouette);
            this.averageSilhouette += nodeSilhouette;
            this.progressTracker.logProgress();
        }
    }

    public double getAverageSilhouette() {
        return this.averageSilhouette / (double)this.communities.size();
    }

    public static SilhouetteTask createTask(NodePropertyValues nodePropertyValues, HugeIntArray communities, HugeDoubleArray silhouette, int k, int dimensions, long[] nodesInCluster, Partition partition, ProgressTracker progressTracker) {
        if (nodePropertyValues.valueType() == ValueType.FLOAT_ARRAY) {
            return new FloatSilhouetteTask(nodePropertyValues, communities, silhouette, k, dimensions, nodesInCluster, partition, progressTracker);
        }
        return new DoubleSilhouetteTask(nodePropertyValues, communities, silhouette, k, dimensions, nodesInCluster, partition, progressTracker);
    }
}

