/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.CommunitySizeConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.NodeWeightConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.config.WriteConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.gds.labelpropagation.LabelPropagationWriteConfig;

@Generated(from="LabelPropagationWriteConfig", generator="Immutables")
public final class ImmutableLabelPropagationWriteConfig
implements LabelPropagationWriteConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    @Nullable
    private final String seedProperty;
    private final boolean consecutiveIds;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    @Nullable
    private final String nodeWeightProperty;
    private final int maxIterations;
    private final int writeConcurrency;
    private final String writeProperty;
    private final Long minCommunitySize;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableLabelPropagationWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, Optional<String> relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Optional<Long> minCommunitySize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.nodeWeightProperty(nodeWeightProperty);
        this.initShim.maxIterations(maxIterations);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.minCommunitySize = minCommunitySize.orElse(null);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableLabelPropagationWriteConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Long minCommunitySize) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(nodeLabels, true, false)));
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.nodeWeightProperty(nodeWeightProperty);
        this.initShim.maxIterations(maxIterations);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
        this.minCommunitySize = minCommunitySize;
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableLabelPropagationWriteConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.writeProperty = builder.writeProperty;
        this.minCommunitySize = builder.minCommunitySize;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableLabelPropagationWriteConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableLabelPropagationWriteConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.seedPropertyIsSet()) {
            this.initShim.seedProperty(builder.seedProperty);
        }
        if (builder.consecutiveIdsIsSet()) {
            this.initShim.consecutiveIds(builder.consecutiveIds);
        }
        if (builder.nodeWeightPropertyIsSet()) {
            this.initShim.nodeWeightProperty(builder.nodeWeightProperty);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.writeConcurrencyIsSet()) {
            this.initShim.writeConcurrency(builder.writeConcurrency);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private ImmutableLabelPropagationWriteConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Long minCommunitySize) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.initShim.seedProperty(seedProperty);
        this.initShim.consecutiveIds(consecutiveIds);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.nodeWeightProperty(nodeWeightProperty);
        this.initShim.maxIterations(maxIterations);
        this.initShim.writeConcurrency(writeConcurrency);
        this.writeProperty = writeProperty;
        this.minCommunitySize = minCommunitySize;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.seedProperty = this.initShim.seedProperty();
        this.consecutiveIds = this.initShim.consecutiveIds();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.nodeWeightProperty = this.initShim.nodeWeightProperty();
        this.maxIterations = this.initShim.maxIterations();
        this.writeConcurrency = this.initShim.writeConcurrency();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return LabelPropagationWriteConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return LabelPropagationWriteConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return LabelPropagationWriteConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return LabelPropagationWriteConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return LabelPropagationWriteConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return LabelPropagationWriteConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return LabelPropagationWriteConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return LabelPropagationWriteConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return LabelPropagationWriteConfig.super.nodeLabels();
    }

    @Nullable
    private String seedPropertyInitialize() {
        return LabelPropagationWriteConfig.super.seedProperty();
    }

    private boolean consecutiveIdsInitialize() {
        return LabelPropagationWriteConfig.super.consecutiveIds();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return LabelPropagationWriteConfig.super.hasRelationshipWeightProperty();
    }

    @Nullable
    private String nodeWeightPropertyInitialize() {
        return LabelPropagationWriteConfig.super.nodeWeightProperty();
    }

    private int maxIterationsInitialize() {
        return LabelPropagationWriteConfig.super.maxIterations();
    }

    private int writeConcurrencyInitialize() {
        return LabelPropagationWriteConfig.super.writeConcurrency();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    @Nullable
    public String seedProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.seedProperty() : this.seedProperty;
    }

    public boolean consecutiveIds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.consecutiveIds() : this.consecutiveIds;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    @Nullable
    public String nodeWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeWeightProperty() : this.nodeWeightProperty;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    public int writeConcurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.writeConcurrency() : this.writeConcurrency;
    }

    public String writeProperty() {
        return this.writeProperty;
    }

    public Optional<Long> minCommunitySize() {
        return Optional.ofNullable(this.minCommunitySize);
    }

    public final ImmutableLabelPropagationWriteConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(elements, true, false));
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(elements, true, false));
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withSeedProperty(@Nullable String value) {
        if (Objects.equals(this.seedProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withConsecutiveIds(boolean value) {
        if (this.consecutiveIds == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, value, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, newValue, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, value, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withNodeWeightProperty(@Nullable String value) {
        if (Objects.equals(this.nodeWeightProperty, value)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, value, this.maxIterations, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, value, this.writeConcurrency, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withWriteConcurrency(int value) {
        if (this.writeConcurrency == value) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, value, this.writeProperty, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withWriteProperty(String value) {
        String newValue = Objects.requireNonNull(value, "writeProperty");
        if (this.writeProperty.equals(newValue)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, newValue, this.minCommunitySize));
    }

    public final ImmutableLabelPropagationWriteConfig withMinCommunitySize(Long value) {
        Long newValue = value;
        if (Objects.equals(this.minCommunitySize, newValue)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, newValue));
    }

    public final ImmutableLabelPropagationWriteConfig withMinCommunitySize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.minCommunitySize, value)) {
            return this;
        }
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.seedProperty, this.consecutiveIds, this.relationshipWeightProperty, this.nodeWeightProperty, this.maxIterations, this.writeConcurrency, this.writeProperty, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLabelPropagationWriteConfig && this.equalTo((ImmutableLabelPropagationWriteConfig)another);
    }

    private boolean equalTo(ImmutableLabelPropagationWriteConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.seedProperty, another.seedProperty) && this.consecutiveIds == another.consecutiveIds && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.nodeWeightProperty, another.nodeWeightProperty) && this.maxIterations == another.maxIterations && this.writeConcurrency == another.writeConcurrency && this.writeProperty.equals(another.writeProperty) && Objects.equals(this.minCommunitySize, another.minCommunitySize);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.seedProperty);
        h += (h << 5) + Boolean.hashCode(this.consecutiveIds);
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.nodeWeightProperty);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + this.writeConcurrency;
        h += (h << 5) + this.writeProperty.hashCode();
        h += (h << 5) + Objects.hashCode(this.minCommunitySize);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LabelPropagationWriteConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 28) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.seedProperty != null) {
            builder.append(", ");
            builder.append("seedProperty=").append(this.seedProperty);
        }
        builder.append(", ");
        builder.append("consecutiveIds=").append(this.consecutiveIds);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.nodeWeightProperty != null) {
            builder.append(", ");
            builder.append("nodeWeightProperty=").append(this.nodeWeightProperty);
        }
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("writeConcurrency=").append(this.writeConcurrency);
        builder.append(", ");
        builder.append("writeProperty=").append(this.writeProperty);
        if (this.minCommunitySize != null) {
            builder.append(", ");
            builder.append("minCommunitySize=").append(this.minCommunitySize);
        }
        return builder.append("}").toString();
    }

    public static LabelPropagationWriteConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, Optional<String> relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Optional<Long> minCommunitySize) {
        return ImmutableLabelPropagationWriteConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, nodeWeightProperty, maxIterations, writeConcurrency, writeProperty, minCommunitySize);
    }

    public static LabelPropagationWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, Optional<String> relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Optional<Long> minCommunitySize) {
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, nodeWeightProperty, maxIterations, writeConcurrency, writeProperty, minCommunitySize));
    }

    public static LabelPropagationWriteConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, @Nullable String seedProperty, boolean consecutiveIds, String relationshipWeightProperty, @Nullable String nodeWeightProperty, int maxIterations, int writeConcurrency, String writeProperty, Long minCommunitySize) {
        return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, seedProperty, consecutiveIds, relationshipWeightProperty, nodeWeightProperty, maxIterations, writeConcurrency, writeProperty, minCommunitySize));
    }

    private static ImmutableLabelPropagationWriteConfig validate(ImmutableLabelPropagationWriteConfig instance) {
        instance.validateWriteConcurrency();
        instance.validateRelationshipWeightProperty();
        instance.forbidSeedingAndConsecutiveIds();
        instance.validateConcurrency();
        return instance;
    }

    public static LabelPropagationWriteConfig copyOf(LabelPropagationWriteConfig instance) {
        if (instance instanceof ImmutableLabelPropagationWriteConfig) {
            return (ImmutableLabelPropagationWriteConfig)instance;
        }
        return ImmutableLabelPropagationWriteConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LabelPropagationWriteConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_WRITE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SEED_PROPERTY = 64L;
        private static final long OPT_BIT_CONSECUTIVE_IDS = 128L;
        private static final long OPT_BIT_NODE_WEIGHT_PROPERTY = 256L;
        private static final long OPT_BIT_MAX_ITERATIONS = 512L;
        private static final long OPT_BIT_WRITE_CONCURRENCY = 1024L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String seedProperty;
        private boolean consecutiveIds;
        private String relationshipWeightProperty;
        private String nodeWeightProperty;
        private int maxIterations;
        private int writeConcurrency;
        private String writeProperty;
        private Long minCommunitySize;

        private Builder() {
        }

        public final Builder from(LabelPropagationBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(WritePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CommunitySizeConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NodeWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConsecutiveIdsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(LabelPropagationWriteConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional relationshipWeightPropertyOptional;
            String nodeWeightPropertyValue;
            String seedPropertyValue;
            Optional minCommunitySizeOptional;
            LabelPropagationBaseConfig instance;
            long bits = 0L;
            if (object instanceof LabelPropagationBaseConfig) {
                instance = (LabelPropagationBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
            if (object instanceof WriteConfig) {
                instance = (WriteConfig)object;
                this.writeConcurrency(instance.writeConcurrency());
            }
            if (object instanceof WritePropertyConfig) {
                instance = (WritePropertyConfig)object;
                this.writeProperty(instance.writeProperty());
            }
            if (object instanceof CommunitySizeConfig && (minCommunitySizeOptional = (instance = (CommunitySizeConfig)object).minCommunitySize()).isPresent()) {
                this.minCommunitySize(minCommunitySizeOptional);
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof SeedConfig && (seedPropertyValue = (instance = (SeedConfig)object).seedProperty()) != null) {
                this.seedProperty(seedPropertyValue);
            }
            if (object instanceof NodeWeightConfig && (nodeWeightPropertyValue = (instance = (NodeWeightConfig)object).nodeWeightProperty()) != null) {
                this.nodeWeightProperty(nodeWeightPropertyValue);
            }
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ConsecutiveIdsConfig) {
                instance = (ConsecutiveIdsConfig)object;
                this.consecutiveIds(instance.consecutiveIds());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder seedProperty(@Nullable String seedProperty) {
            this.seedProperty = seedProperty;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder nodeWeightProperty(@Nullable String nodeWeightProperty) {
            this.nodeWeightProperty = nodeWeightProperty;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder writeProperty(String writeProperty) {
            this.writeProperty = Objects.requireNonNull(writeProperty, "writeProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder minCommunitySize(Long minCommunitySize) {
            this.minCommunitySize = minCommunitySize;
            return this;
        }

        public final Builder minCommunitySize(Optional<Long> minCommunitySize) {
            this.minCommunitySize = minCommunitySize.orElse(null);
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.seedProperty = null;
            this.consecutiveIds = false;
            this.relationshipWeightProperty = null;
            this.nodeWeightProperty = null;
            this.maxIterations = 0;
            this.writeConcurrency = 0;
            this.writeProperty = null;
            this.minCommunitySize = null;
            return this;
        }

        public LabelPropagationWriteConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableLabelPropagationWriteConfig.validate(new ImmutableLabelPropagationWriteConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean seedPropertyIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean consecutiveIdsIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean nodeWeightPropertyIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean writeConcurrencyIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("writeProperty");
            }
            return "Cannot build LabelPropagationWriteConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="LabelPropagationWriteConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte seedPropertyBuildStage = 0;
        private String seedProperty;
        private byte consecutiveIdsBuildStage = 0;
        private boolean consecutiveIds;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte nodeWeightPropertyBuildStage = 0;
        private String nodeWeightProperty;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte writeConcurrencyBuildStage = 0;
        private int writeConcurrency;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableLabelPropagationWriteConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableLabelPropagationWriteConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableLabelPropagationWriteConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableLabelPropagationWriteConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableLabelPropagationWriteConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableLabelPropagationWriteConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableLabelPropagationWriteConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(ImmutableLabelPropagationWriteConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableLabelPropagationWriteConfig.createUnmodifiableList(false, ImmutableLabelPropagationWriteConfig.createSafeList(ImmutableLabelPropagationWriteConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        String seedProperty() {
            if (this.seedPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.seedPropertyBuildStage == 0) {
                this.seedPropertyBuildStage = (byte)-1;
                this.seedProperty = ImmutableLabelPropagationWriteConfig.this.seedPropertyInitialize();
                this.seedPropertyBuildStage = 1;
            }
            return this.seedProperty;
        }

        void seedProperty(String seedProperty) {
            this.seedProperty = seedProperty;
            this.seedPropertyBuildStage = 1;
        }

        boolean consecutiveIds() {
            if (this.consecutiveIdsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.consecutiveIdsBuildStage == 0) {
                this.consecutiveIdsBuildStage = (byte)-1;
                this.consecutiveIds = ImmutableLabelPropagationWriteConfig.this.consecutiveIdsInitialize();
                this.consecutiveIdsBuildStage = 1;
            }
            return this.consecutiveIds;
        }

        void consecutiveIds(boolean consecutiveIds) {
            this.consecutiveIds = consecutiveIds;
            this.consecutiveIdsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableLabelPropagationWriteConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        String nodeWeightProperty() {
            if (this.nodeWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeWeightPropertyBuildStage == 0) {
                this.nodeWeightPropertyBuildStage = (byte)-1;
                this.nodeWeightProperty = ImmutableLabelPropagationWriteConfig.this.nodeWeightPropertyInitialize();
                this.nodeWeightPropertyBuildStage = 1;
            }
            return this.nodeWeightProperty;
        }

        void nodeWeightProperty(String nodeWeightProperty) {
            this.nodeWeightProperty = nodeWeightProperty;
            this.nodeWeightPropertyBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutableLabelPropagationWriteConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        int writeConcurrency() {
            if (this.writeConcurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.writeConcurrencyBuildStage == 0) {
                this.writeConcurrencyBuildStage = (byte)-1;
                this.writeConcurrency = ImmutableLabelPropagationWriteConfig.this.writeConcurrencyInitialize();
                this.writeConcurrencyBuildStage = 1;
            }
            return this.writeConcurrency;
        }

        void writeConcurrency(int writeConcurrency) {
            this.writeConcurrency = writeConcurrency;
            this.writeConcurrencyBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.seedPropertyBuildStage == -1) {
                attributes.add("seedProperty");
            }
            if (this.consecutiveIdsBuildStage == -1) {
                attributes.add("consecutiveIds");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.nodeWeightPropertyBuildStage == -1) {
                attributes.add("nodeWeightProperty");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.writeConcurrencyBuildStage == -1) {
                attributes.add("writeConcurrency");
            }
            return "Cannot build LabelPropagationWriteConfig, attribute initializers form cycle " + attributes;
        }
    }
}

