/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import java.util.PrimitiveIterator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.collection.primitive.PrimitiveLongIterable;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.labelpropagation.ComputeStep;
import org.neo4j.gds.labelpropagation.Step;

final class InitStep
implements Step {
    private final NodePropertyValues nodePropertyValues;
    private final HugeLongArray existingLabels;
    private final PrimitiveLongIterable nodes;
    private final Graph graph;
    private final NodePropertyValues nodeWeights;
    private final ProgressTracker progressTracker;
    private final long maxLabelId;

    InitStep(Graph graph, NodePropertyValues nodePropertyValues, NodePropertyValues nodeWeights, PrimitiveLongIterable nodes, HugeLongArray existingLabels, ProgressTracker progressTracker, long maxLabelId) {
        this.nodePropertyValues = nodePropertyValues;
        this.existingLabels = existingLabels;
        this.nodes = nodes;
        this.graph = graph;
        this.nodeWeights = nodeWeights;
        this.progressTracker = progressTracker;
        this.maxLabelId = maxLabelId;
    }

    @Override
    public void run() {
        PrimitiveIterator.OfLong iterator = this.nodes.iterator();
        while (iterator.hasNext()) {
            long nodeId = iterator.nextLong();
            long existingLabelValue = this.nodePropertyValues.longValue(nodeId);
            long existingLabel = existingLabelValue == Long.MIN_VALUE ? this.maxLabelId + this.graph.toOriginalNodeId(nodeId) + 1L : existingLabelValue;
            this.existingLabels.set(nodeId, existingLabel);
            this.progressTracker.logProgress((long)this.graph.degree(nodeId));
        }
    }

    @Override
    public boolean didConverge() {
        return false;
    }

    @Override
    public Step next() {
        return new ComputeStep(this.graph, this.nodeWeights, this.progressTracker, this.existingLabels, this.nodes);
    }
}

