/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.labelpropagation;

import com.carrotsearch.hppc.LongDoubleScatterMap;
import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.labelpropagation.ComputeStep;
import org.neo4j.gds.labelpropagation.ComputeStepConsumer;
import org.neo4j.gds.labelpropagation.InitStep;
import org.neo4j.gds.labelpropagation.LabelPropagation;
import org.neo4j.gds.labelpropagation.LabelPropagationBaseConfig;
import org.neo4j.gds.labelpropagation.StepRunner;
import org.neo4j.gds.mem.MemoryUsage;

public class LabelPropagationFactory<CONFIG extends LabelPropagationBaseConfig>
extends GraphAlgorithmFactory<LabelPropagation, CONFIG> {
    public String taskName() {
        return "LabelPropagation";
    }

    public LabelPropagation build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return new LabelPropagation(graph, (LabelPropagationBaseConfig)configuration, Pools.DEFAULT, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(LabelPropagation.class).perNode("labels", HugeLongArray::memoryEstimation).perThread("votes", MemoryEstimations.builder().field("init step", InitStep.class).field("compute step", ComputeStep.class).field("step runner", StepRunner.class).field("compute step consumer", ComputeStepConsumer.class).field("votes container", LongDoubleScatterMap.class).rangePerNode("votes", nodeCount -> {
            long minBufferSize = MemoryUsage.sizeOfEmptyOpenHashContainer();
            long maxBufferSize = MemoryUsage.sizeOfOpenHashContainer((long)nodeCount);
            if (maxBufferSize < minBufferSize) {
                maxBufferSize = minBufferSize;
            }
            long min = MemoryUsage.sizeOfLongArray((long)minBufferSize) + MemoryUsage.sizeOfDoubleArray((long)minBufferSize);
            long max = MemoryUsage.sizeOfLongArray((long)maxBufferSize) + MemoryUsage.sizeOfDoubleArray((long)maxBufferSize);
            return MemoryRange.of((long)min, (long)max);
        }).build()).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.task((String)this.taskName(), (Task)Tasks.leaf((String)"Initialization", (long)graph.relationshipCount()), (Task[])new Task[]{Tasks.iterativeDynamic((String)"Assign labels", () -> List.of(Tasks.leaf((String)"Iteration", (long)graph.relationshipCount())), (int)config.maxIterations())});
    }
}

