/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.neo4j.gds.ImmutableRelationshipProjections;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.NativeFactory;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.leiden.RelationshipCreator;

class GraphAggregationPhase {
    private final Graph workingGraph;
    private final HugeLongArray communities;
    private final Direction direction;
    private final long maxCommunityId;
    private final ExecutorService executorService;
    private final int concurrency;
    private final TerminationFlag terminationFlag;
    private final ProgressTracker progressTracker;

    static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder(GraphAggregationPhase.class).rangePerGraphDimension("aggregated graph", (rootDimensions, concurrency) -> {
            long minNodeCount = Math.min(2L, rootDimensions.nodeCount());
            long minRelCount = Math.min(1L, rootDimensions.relCountUpperBound());
            GraphDimensions minDimensions = ImmutableGraphDimensions.builder().nodeCount(minNodeCount).highestPossibleNodeCount(minNodeCount).relationshipCounts(Map.of(RelationshipType.of((String)"foo"), minRelCount)).relCountUpperBound(minRelCount).highestRelationshipId(minRelCount).build();
            RelationshipProjections relationshipProjections = ImmutableRelationshipProjections.builder().putProjection(RelationshipType.of((String)"AGGREGATE"), ((RelationshipProjection.Builder)RelationshipProjection.builder().type("AGGREGATE").orientation(Orientation.UNDIRECTED).aggregation(Aggregation.SUM).addProperty("prop", "prop", DefaultValue.of((Object)1.0))).build()).build();
            MemoryEstimation memoryEstimation = NativeFactory.getMemoryEstimation((NodeProjections)NodeProjections.all(), (RelationshipProjections)relationshipProjections, (boolean)false);
            long min = memoryEstimation.estimate((GraphDimensions)minDimensions, (int)concurrency.intValue()).memoryUsage().min;
            long max = memoryEstimation.estimate((GraphDimensions)rootDimensions, (int)concurrency.intValue()).memoryUsage().max;
            return MemoryRange.of((long)min, (long)max);
        }).perNode("sorted communities", HugeLongArray::memoryEstimation).perNode("atomic coordination array", HugeAtomicLongArray::memoryEstimation).build();
    }

    GraphAggregationPhase(Graph workingGraph, Direction direction, HugeLongArray communities, long maxCommunityId, ExecutorService executorService, int concurrency, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
        this.workingGraph = workingGraph;
        this.communities = communities;
        this.direction = direction;
        this.maxCommunityId = maxCommunityId;
        this.executorService = executorService;
        this.concurrency = concurrency;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
    }

    Graph run() {
        NodesBuilder nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(this.maxCommunityId).concurrency(this.concurrency).build();
        this.terminationFlag.assertRunning();
        ParallelUtil.parallelForEachNode((long)this.workingGraph.nodeCount(), (int)this.concurrency, nodeId -> nodesBuilder.addNode(this.communities.get(nodeId)));
        this.terminationFlag.assertRunning();
        IdMap idMap = nodesBuilder.build().idMap();
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)idMap).relationshipType(RelationshipType.of((String)"_IGNORED_")).orientation(this.direction.toOrientation()).addPropertyConfig(GraphFactory.PropertyConfig.builder().propertyKey("property").aggregation(Aggregation.SUM).build()).executorService(this.executorService).build();
        HugeLongArray sortedNodesByCommunity = GraphAggregationPhase.getNodesSortedByCommunity(this.communities, this.concurrency);
        Function<Long, Integer> customDegree = x -> this.workingGraph.degree(sortedNodesByCommunity.get(x.longValue()));
        List relationshipCreators = PartitionUtils.customDegreePartitionWithBatchSize((Graph)this.workingGraph, (int)this.concurrency, customDegree, partition -> new RelationshipCreator(sortedNodesByCommunity, this.communities, (Partition)partition, relationshipsBuilder, (RelationshipIterator)this.workingGraph.concurrentCopy(), this.direction, this.progressTracker), Optional.empty(), Optional.of(this.workingGraph.relationshipCount()));
        ParallelUtil.run((Collection)relationshipCreators, (ExecutorService)this.executorService);
        return GraphFactory.create((IdMap)idMap, (SingleTypeRelationships)relationshipsBuilder.build());
    }

    static HugeLongArray getNodesSortedByCommunity(HugeLongArray communities, int concurrency) {
        long nodeCount = communities.size();
        HugeLongArray sortedNodesByCommunity = HugeLongArray.newArray((long)nodeCount);
        HugeAtomicLongArray communityCoordinateArray = HugeAtomicLongArray.newArray((long)nodeCount);
        ParallelUtil.parallelForEachNode((long)nodeCount, (int)concurrency, nodeId -> {
            long communityId = communities.get(nodeId);
            communityCoordinateArray.getAndAdd(communityId, 1L);
        });
        AtomicLong atomicNodeSum = new AtomicLong();
        ParallelUtil.parallelForEachNode((long)nodeCount, (int)concurrency, indexId -> {
            if (communityCoordinateArray.get(indexId) > 0L) {
                long nodeSum = atomicNodeSum.addAndGet(communityCoordinateArray.get(indexId));
                communityCoordinateArray.set(indexId, nodeSum);
            }
        });
        ParallelUtil.parallelForEachNode((long)nodeCount, (int)concurrency, indexId -> {
            long nodeId = nodeCount - indexId - 1L;
            long communityId = communities.get(nodeId);
            long coordinate = communityCoordinateArray.getAndAdd(communityId, -1L);
            sortedNodesByCommunity.set(coordinate - 1L, nodeId);
        });
        return sortedNodesByCommunity;
    }
}

