/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.LongUnaryOperator;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.leiden.LeidenDendrogramManager;
import org.neo4j.gds.leiden.LeidenResult;

@Generated(from="LeidenResult", generator="Immutables")
public final class ImmutableLeidenResult
implements LeidenResult {
    private final HugeLongArray communities;
    private final int ranLevels;
    private final boolean didConverge;
    @Nullable
    private final LeidenDendrogramManager dendrogramManager;
    private final double[] modularities;
    private final double modularity;
    private final transient LongUnaryOperator communitiesFunction;

    private ImmutableLeidenResult(HugeLongArray communities, int ranLevels, boolean didConverge, @Nullable LeidenDendrogramManager dendrogramManager, double[] modularities, double modularity) {
        this.communities = Objects.requireNonNull(communities, "communities");
        this.ranLevels = ranLevels;
        this.didConverge = didConverge;
        this.dendrogramManager = dendrogramManager;
        this.modularities = (double[])modularities.clone();
        this.modularity = modularity;
        this.communitiesFunction = Objects.requireNonNull(LeidenResult.super.communitiesFunction(), "communitiesFunction");
    }

    private ImmutableLeidenResult(ImmutableLeidenResult original, HugeLongArray communities, int ranLevels, boolean didConverge, @Nullable LeidenDendrogramManager dendrogramManager, double[] modularities, double modularity) {
        this.communities = communities;
        this.ranLevels = ranLevels;
        this.didConverge = didConverge;
        this.dendrogramManager = dendrogramManager;
        this.modularities = modularities;
        this.modularity = modularity;
        this.communitiesFunction = Objects.requireNonNull(LeidenResult.super.communitiesFunction(), "communitiesFunction");
    }

    @Override
    public HugeLongArray communities() {
        return this.communities;
    }

    @Override
    public int ranLevels() {
        return this.ranLevels;
    }

    @Override
    public boolean didConverge() {
        return this.didConverge;
    }

    @Override
    @Nullable
    public LeidenDendrogramManager dendrogramManager() {
        return this.dendrogramManager;
    }

    @Override
    public double[] modularities() {
        return (double[])this.modularities.clone();
    }

    @Override
    public double modularity() {
        return this.modularity;
    }

    @Override
    public LongUnaryOperator communitiesFunction() {
        return this.communitiesFunction;
    }

    public final ImmutableLeidenResult withCommunities(HugeLongArray value) {
        if (this.communities == value) {
            return this;
        }
        HugeLongArray newValue = Objects.requireNonNull(value, "communities");
        return new ImmutableLeidenResult(this, newValue, this.ranLevels, this.didConverge, this.dendrogramManager, this.modularities, this.modularity);
    }

    public final ImmutableLeidenResult withRanLevels(int value) {
        if (this.ranLevels == value) {
            return this;
        }
        return new ImmutableLeidenResult(this, this.communities, value, this.didConverge, this.dendrogramManager, this.modularities, this.modularity);
    }

    public final ImmutableLeidenResult withDidConverge(boolean value) {
        if (this.didConverge == value) {
            return this;
        }
        return new ImmutableLeidenResult(this, this.communities, this.ranLevels, value, this.dendrogramManager, this.modularities, this.modularity);
    }

    public final ImmutableLeidenResult withDendrogramManager(@Nullable LeidenDendrogramManager value) {
        if (this.dendrogramManager == value) {
            return this;
        }
        return new ImmutableLeidenResult(this, this.communities, this.ranLevels, this.didConverge, value, this.modularities, this.modularity);
    }

    public final ImmutableLeidenResult withModularities(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutableLeidenResult(this, this.communities, this.ranLevels, this.didConverge, this.dendrogramManager, newValue, this.modularity);
    }

    public final ImmutableLeidenResult withModularity(double value) {
        if (Double.doubleToLongBits(this.modularity) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableLeidenResult(this, this.communities, this.ranLevels, this.didConverge, this.dendrogramManager, this.modularities, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLeidenResult && this.equalTo((ImmutableLeidenResult)another);
    }

    private boolean equalTo(ImmutableLeidenResult another) {
        return this.communities.equals(another.communities) && this.ranLevels == another.ranLevels && this.didConverge == another.didConverge && Objects.equals(this.dendrogramManager, another.dendrogramManager) && Arrays.equals(this.modularities, another.modularities) && Double.doubleToLongBits(this.modularity) == Double.doubleToLongBits(another.modularity) && this.communitiesFunction.equals(another.communitiesFunction);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.communities.hashCode();
        h += (h << 5) + this.ranLevels;
        h += (h << 5) + Boolean.hashCode(this.didConverge);
        h += (h << 5) + Objects.hashCode(this.dendrogramManager);
        h += (h << 5) + Arrays.hashCode(this.modularities);
        h += (h << 5) + Double.hashCode(this.modularity);
        h += (h << 5) + this.communitiesFunction.hashCode();
        return h;
    }

    public String toString() {
        return "LeidenResult{communities=" + this.communities + ", ranLevels=" + this.ranLevels + ", didConverge=" + this.didConverge + ", dendrogramManager=" + this.dendrogramManager + ", modularities=" + Arrays.toString(this.modularities) + ", modularity=" + this.modularity + ", communitiesFunction=" + this.communitiesFunction + "}";
    }

    public static LeidenResult of(HugeLongArray communities, int ranLevels, boolean didConverge, @Nullable LeidenDendrogramManager dendrogramManager, double[] modularities, double modularity) {
        return new ImmutableLeidenResult(communities, ranLevels, didConverge, dendrogramManager, modularities, modularity);
    }

    public static LeidenResult copyOf(LeidenResult instance) {
        if (instance instanceof ImmutableLeidenResult) {
            return (ImmutableLeidenResult)instance;
        }
        return ImmutableLeidenResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="LeidenResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COMMUNITIES = 1L;
        private static final long INIT_BIT_RAN_LEVELS = 2L;
        private static final long INIT_BIT_DID_CONVERGE = 4L;
        private static final long INIT_BIT_MODULARITIES = 8L;
        private static final long INIT_BIT_MODULARITY = 16L;
        private long initBits = 31L;
        private HugeLongArray communities;
        private int ranLevels;
        private boolean didConverge;
        private LeidenDendrogramManager dendrogramManager;
        private double[] modularities;
        private double modularity;

        private Builder() {
        }

        public final Builder from(LeidenResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.communities(instance.communities());
            this.ranLevels(instance.ranLevels());
            this.didConverge(instance.didConverge());
            @Nullable LeidenDendrogramManager dendrogramManagerValue = instance.dendrogramManager();
            if (dendrogramManagerValue != null) {
                this.dendrogramManager(dendrogramManagerValue);
            }
            this.modularities(instance.modularities());
            this.modularity(instance.modularity());
            return this;
        }

        public final Builder communities(HugeLongArray communities) {
            this.communities = Objects.requireNonNull(communities, "communities");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder ranLevels(int ranLevels) {
            this.ranLevels = ranLevels;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder didConverge(boolean didConverge) {
            this.didConverge = didConverge;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder dendrogramManager(@Nullable LeidenDendrogramManager dendrogramManager) {
            this.dendrogramManager = dendrogramManager;
            return this;
        }

        public final Builder modularities(double ... modularities) {
            this.modularities = (double[])modularities.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder modularity(double modularity) {
            this.modularity = modularity;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 31L;
            this.communities = null;
            this.ranLevels = 0;
            this.didConverge = false;
            this.dendrogramManager = null;
            this.modularities = null;
            this.modularity = 0.0;
            return this;
        }

        public LeidenResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableLeidenResult(null, this.communities, this.ranLevels, this.didConverge, this.dendrogramManager, this.modularities, this.modularity);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("communities");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ranLevels");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("didConverge");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("modularities");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("modularity");
            }
            return "Cannot build LeidenResult, some of required attributes are not set " + attributes;
        }
    }
}

