/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.concurrent.atomic.DoubleAdder;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.partition.Partition;

class InitVolumeTask
implements Runnable {
    private final Partition partition;
    private final Graph graph;
    private final HugeDoubleArray nodeVolumes;
    private final DoubleAdder totalVolume;

    InitVolumeTask(Graph graph, HugeDoubleArray nodeVolumes, Partition partition, DoubleAdder totalVolume) {
        this.graph = graph;
        this.nodeVolumes = nodeVolumes;
        this.partition = partition;
        this.totalVolume = totalVolume;
    }

    @Override
    public void run() {
        long startId = this.partition.startNode();
        long endId = startId + this.partition.nodeCount();
        for (long nodeId = startId; nodeId < endId; ++nodeId) {
            long finalNodeId = nodeId;
            this.graph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                this.nodeVolumes.addTo(finalNodeId, w);
                this.totalVolume.add(w);
                return true;
            });
        }
    }
}

