/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.List;
import java.util.Optional;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.IterativeTask;
import org.neo4j.gds.core.utils.progress.tasks.LeafTask;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.leiden.GraphAggregationPhase;
import org.neo4j.gds.leiden.Leiden;
import org.neo4j.gds.leiden.LeidenBaseConfig;
import org.neo4j.gds.leiden.LeidenDendrogramManager;
import org.neo4j.gds.leiden.LocalMovePhase;
import org.neo4j.gds.leiden.ModularityComputer;
import org.neo4j.gds.leiden.RefinementPhase;
import org.neo4j.gds.leiden.SeedCommunityManager;

public class LeidenAlgorithmFactory<CONFIG extends LeidenBaseConfig>
extends GraphAlgorithmFactory<Leiden, CONFIG> {
    public Leiden build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        if (!graph.schema().isUndirected()) {
            throw new IllegalArgumentException("The Leiden algorithm works only with undirected graphs. Please orient the edges properly");
        }
        NodePropertyValues seedValues = Optional.ofNullable(configuration.seedProperty()).map(arg_0 -> ((Graph)graph).nodeProperties(arg_0)).orElse(null);
        return new Leiden(graph, configuration.maxLevels(), configuration.gamma(), configuration.theta(), configuration.includeIntermediateCommunities(), configuration.randomSeed().orElse(0L), seedValues, configuration.tolerance(), configuration.concurrency(), progressTracker);
    }

    public String taskName() {
        return "Leiden";
    }

    public Task progressTask(Graph graph, CONFIG config) {
        int iterations = config.maxLevels();
        IterativeTask iterativeTasks = Tasks.iterativeDynamic((String)"Iteration", () -> List.of(Tasks.leaf((String)"Local Move", (long)1L), Tasks.leaf((String)"Modularity Computation", (long)graph.nodeCount()), Tasks.leaf((String)"Refinement", (long)graph.nodeCount()), Tasks.leaf((String)"Aggregation", (long)graph.nodeCount())), (int)iterations);
        LeafTask initilizationTask = Tasks.leaf((String)"Initialization", (long)graph.nodeCount());
        return Tasks.task((String)"Leiden", (Task)initilizationTask, (Task[])new Task[]{iterativeTasks});
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(Leiden.class).perNode("local move communities", HugeLongArray::memoryEstimation).perNode("local move node volumes", HugeDoubleArray::memoryEstimation).perNode("local move community volumes", HugeDoubleArray::memoryEstimation).perNode("current communities", HugeLongArray::memoryEstimation);
        if (config.seedProperty() != null) {
            builder.add("seeded communities", SeedCommunityManager.memoryEstimation());
        }
        builder.add("local move phase", LocalMovePhase.estimation()).add("modularity computation", ModularityComputer.estimation()).add("dendogram manager", LeidenDendrogramManager.memoryEstimation(config.includeIntermediateCommunities() ? config.maxLevels() : 1)).add("refinement phase", RefinementPhase.memoryEstimation()).add("aggregation phase", GraphAggregationPhase.memoryEstimation()).add("post-aggregation phase", MemoryEstimations.builder().perNode("next local move communities", HugeLongArray::memoryEstimation).perNode("next local move node volumes", HugeDoubleArray::memoryEstimation).perNode("next local move community volumes", HugeDoubleArray::memoryEstimation).perNode("community to node map", HugeLongArray::memoryEstimation).build());
        return builder.build();
    }
}

