/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ConsecutiveIdsConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.ToleranceConfig;

public interface LeidenBaseConfig
extends AlgoBaseConfig,
ConsecutiveIdsConfig,
RelationshipWeightConfig,
RandomSeedConfig,
ToleranceConfig {
    @Value.Default
    default public double gamma() {
        return 1.0;
    }

    @Value.Default
    default public double theta() {
        return 0.01;
    }

    @Value.Default
    default public int maxLevels() {
        return 10;
    }

    @Value.Default
    default public boolean includeIntermediateCommunities() {
        return false;
    }

    @Value.Default
    @Configuration.DoubleRange(min=0.0)
    default public double tolerance() {
        return 1.0E-4;
    }

    @Value.Check
    default public void validate() {
        if (this.includeIntermediateCommunities() && this.consecutiveIds()) {
            throw new IllegalArgumentException("`includeIntermediateResults` and the `consecutiveIds` option cannot be used at the same time.");
        }
    }
}

