/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.leiden.SeedCommunityManager;

public class LeidenDendrogramManager {
    private final Graph rootGraph;
    private final long nodeCount;
    private final int concurrency;
    private final boolean trackIntermediateCommunities;
    private final HugeLongArray[] dendrograms;
    private int currentIndex;

    static MemoryEstimation memoryEstimation(int numberOfTrackedIterations) {
        return MemoryEstimations.builder(LeidenDendrogramManager.class).perNode("dendograms", HugeLongArray::memoryEstimation).build().times((long)numberOfTrackedIterations);
    }

    LeidenDendrogramManager(Graph rootGraph, int maxIterations, int concurrency, boolean trackIntermediateCommunities) {
        this.rootGraph = rootGraph;
        this.nodeCount = rootGraph.nodeCount();
        this.concurrency = concurrency;
        this.dendrograms = trackIntermediateCommunities ? new HugeLongArray[maxIterations] : new HugeLongArray[1];
        this.trackIntermediateCommunities = trackIntermediateCommunities;
    }

    public HugeLongArray[] getAllDendrograms() {
        return this.dendrograms;
    }

    public HugeLongArray getCurrent() {
        return this.dendrograms[this.currentIndex];
    }

    private long translateNode(Graph workingGraph, HugeLongArray previousAlgorithmDendrogram, long nodeId, int iteration) {
        return iteration == 0 ? nodeId : workingGraph.toMappedNodeId(previousAlgorithmDendrogram.get(nodeId));
    }

    void updateOutputDendrogram(Graph workingGraph, HugeLongArray previousAlgorithmDendrogram, HugeLongArray communitiesToOuput, SeedCommunityManager seedCommunityManager, int iteration) {
        assert (workingGraph.nodeCount() == communitiesToOuput.size()) : "The sizes of the graph and communities should match";
        this.prepareNextLevel(iteration);
        ParallelUtil.parallelForEachNode((Graph)this.rootGraph, (int)this.concurrency, nodeId -> {
            long prevId = this.translateNode(workingGraph, previousAlgorithmDendrogram, nodeId, iteration);
            long communityId = communitiesToOuput.get(prevId);
            long reverseId = seedCommunityManager.mapToSeed(communityId);
            this.setToOutputDendrogram(nodeId, reverseId);
        });
    }

    void updateAlgorithmDendrogram(Graph workingGraph, HugeLongArray algorithmDendrogram, HugeLongArray communitiesToWrite, int iteration) {
        HugeLongArray finalAlgorithmDendrogram = algorithmDendrogram;
        ParallelUtil.parallelForEachNode((Graph)this.rootGraph, (int)this.concurrency, nodeId -> {
            long prevId = this.translateNode(workingGraph, finalAlgorithmDendrogram, nodeId, iteration);
            long communityId = communitiesToWrite.get(prevId);
            finalAlgorithmDendrogram.set(nodeId, communityId);
        });
    }

    private void prepareNextLevel(int iteration) {
        int n = this.currentIndex = this.trackIntermediateCommunities ? iteration : 0;
        if (this.currentIndex > 0 || iteration == 0) {
            this.dendrograms[this.currentIndex] = HugeLongArray.newArray((long)this.nodeCount);
        }
    }

    private void setToOutputDendrogram(long nodeId, long communityId) {
        this.dendrograms[this.currentIndex].set(nodeId, communityId);
    }
}

