/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.function.LongUnaryOperator;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.leiden.ImmutableLeidenResult;
import org.neo4j.gds.leiden.LeidenDendrogramManager;

@ValueClass
public interface LeidenResult {
    public HugeLongArray communities();

    public int ranLevels();

    public boolean didConverge();

    @Nullable
    public LeidenDendrogramManager dendrogramManager();

    public double[] modularities();

    public double modularity();

    default public long[] getIntermediateCommunities(long nodeId) {
        if (this.dendrogramManager() != null) {
            HugeLongArray[] dendrograms = this.dendrogramManager().getAllDendrograms();
            int levels = this.ranLevels();
            long[] communities = new long[levels];
            for (int i = 0; i < levels; ++i) {
                communities[i] = dendrograms[i].get(nodeId);
            }
            return communities;
        }
        return new long[]{this.communities().get(nodeId)};
    }

    @Value.Derived
    default public LongUnaryOperator communitiesFunction() {
        return arg_0 -> ((HugeLongArray)this.communities()).get(arg_0);
    }

    public static LeidenResult of(HugeLongArray communities, int ranLevels, boolean didConverge, @Nullable LeidenDendrogramManager dendrogramManager, double[] modularities, double modularity) {
        return ImmutableLeidenResult.of(communities, ranLevels, didConverge, dendrogramManager, modularities, modularity);
    }
}

