/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

class LeidenUtils {
    LeidenUtils() {
    }

    static HugeLongArray createSingleNodeCommunities(long nodeCount) {
        HugeLongArray array = HugeLongArray.newArray((long)nodeCount);
        array.setAll(v -> v);
        return array;
    }

    static HugeLongArray createSeedCommunities(long nodeCount, NodePropertyValues seedValues) {
        HugeLongArray array = HugeLongArray.newArray((long)nodeCount);
        long longMaxId = seedValues.getMaxLongPropertyValue().getAsLong();
        if (longMaxId < 0L) {
            longMaxId = 0L;
        }
        AtomicLong maxId = new AtomicLong(longMaxId);
        array.setAll(v -> {
            long seedValue = seedValues.longValue(v);
            if (seedValue < 0L && seedValue != Long.MIN_VALUE) {
                throw new IllegalArgumentException("Seed values should be non-negative");
            }
            return seedValue >= 0L ? seedValue : maxId.incrementAndGet();
        });
        return array;
    }

    static HugeLongArray createStartingCommunities(long nodeCount, @Nullable NodePropertyValues seedValues) {
        return seedValues == null ? LeidenUtils.createSingleNodeCommunities(nodeCount) : LeidenUtils.createSeedCommunities(nodeCount, seedValues);
    }
}

