/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.leiden.LocalMoveTask;

final class LocalMovePhase {
    private final Graph graph;
    private final HugeLongArray currentCommunities;
    private final HugeDoubleArray nodeVolumes;
    private final HugeDoubleArray communityVolumes;
    private final double gamma;
    private final int concurrency;
    long swaps;

    static MemoryEstimation estimation() {
        return MemoryEstimations.builder(LocalMovePhase.class).perNode("community weights", HugeDoubleArray::memoryEstimation).perNode("community volumes", HugeAtomicDoubleArray::memoryEstimation).perNode("global queue", HugeLongArray::memoryEstimation).perNode("global queue bitset", HugeAtomicBitSet::memoryEstimation).perThread("local move task", LocalMoveTask.estimation()).build();
    }

    static LocalMovePhase create(Graph graph, HugeLongArray seedCommunities, HugeDoubleArray nodeVolumes, HugeDoubleArray communityVolumes, double gamma, int concurrency) {
        return new LocalMovePhase(graph, seedCommunities, nodeVolumes, communityVolumes, gamma, concurrency);
    }

    private LocalMovePhase(Graph graph, HugeLongArray seedCommunities, HugeDoubleArray nodeVolumes, HugeDoubleArray communityVolumes, double gamma, int concurrency) {
        this.graph = graph;
        this.currentCommunities = seedCommunities;
        this.gamma = gamma;
        this.nodeVolumes = nodeVolumes;
        this.communityVolumes = communityVolumes;
        this.swaps = 0L;
        this.concurrency = concurrency;
    }

    public void run() {
        HugeAtomicDoubleArray atomicCommunityVolumes = HugeAtomicDoubleArray.newArray((long)this.graph.nodeCount());
        this.graph.forEachNode(v -> {
            atomicCommunityVolumes.set(v, this.communityVolumes.get(v));
            return true;
        });
        HugeLongArray globalQueue = HugeLongArray.newArray((long)this.graph.nodeCount());
        AtomicLong globalQueueIndex = new AtomicLong();
        AtomicLong globalQueueSize = new AtomicLong(this.graph.nodeCount());
        HugeAtomicBitSet nodeInQueue = HugeAtomicBitSet.create((long)this.graph.nodeCount());
        nodeInQueue.set(0L, this.graph.nodeCount());
        this.graph.forEachNode(v -> {
            globalQueue.set(v, v);
            return true;
        });
        ArrayList<LocalMoveTask> tasks = new ArrayList<LocalMoveTask>();
        for (int i = 0; i < this.concurrency; ++i) {
            tasks.add(new LocalMoveTask(this.graph.concurrentCopy(), this.currentCommunities, atomicCommunityVolumes, this.nodeVolumes, globalQueue, globalQueueIndex, globalQueueSize, nodeInQueue, this.gamma));
        }
        while (globalQueueSize.get() > 0L) {
            globalQueueIndex.set(0L);
            RunWithConcurrency.builder().tasks(tasks).concurrency(this.concurrency).run();
            globalQueueSize.set(0L);
            RunWithConcurrency.builder().tasks(tasks).concurrency(this.concurrency).run();
        }
        for (LocalMoveTask task : tasks) {
            this.swaps += task.swaps;
        }
        this.graph.forEachNode(v -> {
            this.communityVolumes.set(v, atomicCommunityVolumes.get(v));
            return true;
        });
    }
}

