/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicBitSet;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongArrayQueue;

public class LocalMoveTask
implements Runnable {
    private static final long LOCAL_QUEUE_BOUND = 1000L;
    private final Graph graph;
    private final AtomicLong globalQueueIndex;
    private final HugeLongArray encounteredCommunities;
    private final HugeDoubleArray encounteredCommunitiesWeights;
    private final HugeDoubleArray nodeVolumes;
    private final HugeLongArray globalQueue;
    private final AtomicLong globalQueueSize;
    private final HugeAtomicBitSet nodeInQueue;
    private final HugeLongArrayQueue localQueue;
    private final HugeLongArray currentCommunities;
    private final HugeAtomicDoubleArray communityVolumes;
    private long encounteredCommunityCounter = 0L;
    private LocalMoveTaskPhase phase;
    private final double gamma;
    long swaps;

    static MemoryEstimation estimation() {
        return MemoryEstimations.builder().perNode("neighbor communities", HugeLongArray::memoryEstimation).perNode("neighbor weights", HugeDoubleArray::memoryEstimation).add("local queue", HugeLongArrayQueue.memoryEstimation()).build();
    }

    public LocalMoveTask(Graph graph, HugeLongArray currentCommunities, HugeAtomicDoubleArray communityVolumes, HugeDoubleArray nodeVolumes, HugeLongArray globalQueue, AtomicLong globalQueueIndex, AtomicLong globalQueueSize, HugeAtomicBitSet nodeInQueue, double gamma) {
        this.graph = graph;
        this.globalQueue = globalQueue;
        this.globalQueueIndex = globalQueueIndex;
        this.globalQueueSize = globalQueueSize;
        this.encounteredCommunities = HugeLongArray.newArray((long)graph.nodeCount());
        this.encounteredCommunitiesWeights = HugeDoubleArray.newArray((long)graph.nodeCount());
        this.encounteredCommunitiesWeights.setAll(c -> -1.0);
        this.nodeVolumes = nodeVolumes;
        this.communityVolumes = communityVolumes;
        this.currentCommunities = currentCommunities;
        this.nodeInQueue = nodeInQueue;
        this.localQueue = HugeLongArrayQueue.newQueue((long)graph.nodeCount());
        this.gamma = gamma;
        this.phase = LocalMoveTaskPhase.RUN;
    }

    @Override
    public void run() {
        if (this.phase == LocalMoveTaskPhase.RUN) {
            long offset;
            while ((offset = this.globalQueueIndex.getAndAdd(64L)) < this.globalQueueSize.get()) {
                long chunkSize = Math.min(offset + 64L, this.globalQueueSize.get());
                for (long idx = offset; idx < chunkSize; ++idx) {
                    long nodeId = this.globalQueue.get(idx);
                    this.processNode(nodeId);
                }
            }
            while (this.localQueue.size() > 0L && this.localQueue.size() < 1000L) {
                long nodeId = this.localQueue.remove();
                this.processNode(nodeId);
            }
            this.phase = LocalMoveTaskPhase.SYNC;
        } else {
            this.sync();
            this.phase = LocalMoveTaskPhase.RUN;
        }
    }

    private void sync() {
        long currentIndex = this.globalQueueSize.getAndAdd(this.localQueue.size());
        while (!this.localQueue.isEmpty()) {
            this.globalQueue.set(currentIndex++, this.localQueue.remove());
        }
    }

    private void moveNodeToNewCommunity(long nodeId, long newCommunityId, double currentNodeVolume) {
        long oldCommunityId = this.currentCommunities.get(nodeId);
        this.currentCommunities.set(nodeId, newCommunityId);
        this.communityVolumes.getAndAdd(newCommunityId, currentNodeVolume);
        this.communityVolumes.update(oldCommunityId, oldValue -> {
            double diff = oldValue - currentNodeVolume;
            return Math.max(diff, 0.0);
        });
        ++this.swaps;
    }

    private void findCommunityRelationshipWeights(long nodeId) {
        this.encounteredCommunityCounter = 0L;
        this.graph.forEachRelationship(nodeId, 1.0, (s, t, relationshipWeight) -> {
            long tCommunity = this.currentCommunities.get(t);
            if (this.encounteredCommunitiesWeights.get(tCommunity) < 0.0) {
                this.encounteredCommunities.set(this.encounteredCommunityCounter, tCommunity);
                ++this.encounteredCommunityCounter;
                this.encounteredCommunitiesWeights.set(tCommunity, relationshipWeight);
            } else {
                this.encounteredCommunitiesWeights.addTo(tCommunity, relationshipWeight);
            }
            return true;
        });
    }

    private void visitNeighboursAfterMove(long nodeId, long movedToCommunityId) {
        this.graph.forEachRelationship(nodeId, (s, t) -> {
            boolean shouldAddInQueue;
            long tCommunity = this.currentCommunities.get(t);
            boolean bl = shouldAddInQueue = !this.nodeInQueue.get(t) && tCommunity != movedToCommunityId;
            if (shouldAddInQueue && !this.nodeInQueue.getAndSet(t)) {
                this.localQueue.add(t);
            }
            return true;
        });
    }

    private void tryToMoveNode(long nodeId, long currentNodeCommunityId, double currentNodeVolume, long bestCommunityId) {
        boolean shouldChangeCommunity;
        boolean bl = shouldChangeCommunity = bestCommunityId != currentNodeCommunityId;
        if (shouldChangeCommunity) {
            this.moveNodeToNewCommunity(nodeId, bestCommunityId, currentNodeVolume);
            this.visitNeighboursAfterMove(nodeId, bestCommunityId);
        }
    }

    private long findBestCommunity(double currentBestGain, double currentNodeVolume, long bestCommunityId, long communityId) {
        for (long i = 0L; i < this.encounteredCommunityCounter; ++i) {
            boolean improves;
            long candidateCommunityId = this.encounteredCommunities.get(i);
            double candidateCommunityRelationshipsWeight = this.encounteredCommunitiesWeights.get(candidateCommunityId);
            this.encounteredCommunitiesWeights.set(candidateCommunityId, -1.0);
            if (candidateCommunityId == communityId) continue;
            double modularityGain = candidateCommunityRelationshipsWeight - currentNodeVolume * this.communityVolumes.get(candidateCommunityId) * this.gamma;
            boolean bl = improves = modularityGain > currentBestGain || modularityGain > 0.0 && Double.compare(modularityGain, currentBestGain) == 0 && candidateCommunityId < bestCommunityId;
            if (!improves) continue;
            bestCommunityId = candidateCommunityId;
            currentBestGain = modularityGain;
        }
        return bestCommunityId;
    }

    private void processNode(long nodeId) {
        this.nodeInQueue.clear(nodeId);
        long currentNodeCommunityId = this.currentCommunities.get(nodeId);
        double currentNodeVolume = this.nodeVolumes.get(nodeId);
        double modifiedCommunityVolume = this.communityVolumes.get(currentNodeCommunityId) - currentNodeVolume;
        this.findCommunityRelationshipWeights(nodeId);
        double currentBestGain = Math.max(0.0, this.encounteredCommunitiesWeights.get(currentNodeCommunityId)) - currentNodeVolume * modifiedCommunityVolume * this.gamma;
        long bestCommunityId = this.findBestCommunity(currentBestGain, currentNodeVolume, currentNodeCommunityId, currentNodeCommunityId);
        this.tryToMoveNode(nodeId, currentNodeCommunityId, currentNodeVolume, bestCommunityId);
    }

    static enum LocalMoveTaskPhase {
        RUN,
        SYNC;

    }
}

