/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

public final class ModularityComputer {
    static MemoryEstimation estimation() {
        return MemoryEstimations.builder(ModularityComputer.class).perNode("relationships outside community", HugeAtomicDoubleArray::memoryEstimation).perThread("relationship calculator", MemoryEstimations.builder(OutsideRelationshipCalculator.class).build()).build();
    }

    private ModularityComputer() {
    }

    static double compute(Graph workingGraph, HugeLongArray communities, HugeDoubleArray communityVolumes, double gamma, double coefficient, int concurrency, ExecutorService executorService, ProgressTracker progressTracker) {
        HugeAtomicDoubleArray relationshipsOutsideCommunity = HugeAtomicDoubleArray.newArray((long)workingGraph.nodeCount());
        List tasks = PartitionUtils.rangePartition((int)concurrency, (long)workingGraph.nodeCount(), partition -> new OutsideRelationshipCalculator((Partition)partition, workingGraph, relationshipsOutsideCommunity, communities, progressTracker), Optional.empty());
        RunWithConcurrency.builder().concurrency(concurrency).tasks((Iterable)tasks).executor(executorService).run();
        double modularity = (Double)ParallelUtil.parallelStream((BaseStream)LongStream.range(0L, workingGraph.nodeCount()), (int)concurrency, nodeStream -> nodeStream.mapToDouble(communityId -> {
            double outsideRelationships = relationshipsOutsideCommunity.get(communityId);
            double totalRelationships = communityVolumes.get(communityId);
            double insideRelationships = totalRelationships - outsideRelationships;
            return insideRelationships - totalRelationships * totalRelationships * gamma;
        }).reduce(Double::sum).orElseThrow(() -> new RuntimeException("Error while computing modularity")));
        return modularity * coefficient;
    }

    static class OutsideRelationshipCalculator
    implements Runnable {
        private final Partition partition;
        private final Graph localGraph;
        private final HugeAtomicDoubleArray relationshipsOutsideCommunity;
        private final HugeLongArray communities;
        private final ProgressTracker progressTracker;

        OutsideRelationshipCalculator(Partition partition, Graph graph, HugeAtomicDoubleArray relationshipsOutsideCommunity, HugeLongArray communities, ProgressTracker progressTracker) {
            this.partition = partition;
            this.localGraph = graph.concurrentCopy();
            this.relationshipsOutsideCommunity = relationshipsOutsideCommunity;
            this.communities = communities;
            this.progressTracker = progressTracker;
        }

        @Override
        public void run() {
            long startNode = this.partition.startNode();
            long endNode = startNode + this.partition.nodeCount();
            for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
                long communityId = this.communities.get(nodeId);
                this.localGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                    long tCommunityId = this.communities.get(t);
                    if (tCommunityId != communityId) {
                        this.relationshipsOutsideCommunity.getAndAdd(communityId, w);
                    }
                    return true;
                });
                this.progressTracker.logProgress();
            }
        }
    }
}

