/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;

public class RefinementBetweenRelationshipCounter
implements Runnable {
    private final Graph graph;
    private final Partition partition;
    private final HugeDoubleArray relationshipsBetweenCommunities;
    private final HugeLongArray originalCommunities;

    public RefinementBetweenRelationshipCounter(Graph graph, HugeDoubleArray relationshipsBetweenCommunities, HugeLongArray originalCommunities, Partition partition) {
        this.graph = graph;
        this.relationshipsBetweenCommunities = relationshipsBetweenCommunities;
        this.partition = partition;
        this.originalCommunities = originalCommunities;
    }

    @Override
    public void run() {
        long startNode = this.partition.startNode();
        long endNode = startNode + this.partition.nodeCount();
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            long originalCommunityId = this.originalCommunities.get(nodeId);
            long finalNodeId = nodeId;
            this.graph.forEachRelationship(nodeId, 1.0, (s, t, relationshipWeight) -> {
                long tOriginalCommunityId = this.originalCommunities.get(t);
                if (originalCommunityId == tOriginalCommunityId) {
                    this.relationshipsBetweenCommunities.addTo(finalNodeId, relationshipWeight);
                }
                return true;
            });
        }
    }
}

