/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;

final class RelationshipCreator
implements Runnable {
    private final Direction direction;
    private final RelationshipsBuilder relationshipsBuilder;
    private final HugeLongArray communities;
    private final RelationshipIterator relationshipIterator;
    private final Partition partition;
    private final ProgressTracker progressTracker;
    private final HugeDoubleArray encounteredCommunityWeights;
    private final HugeLongArray encounteredCommunities;
    private long encountereCommunitiesCounter;
    private final HugeLongArray sortedByCommunity;

    RelationshipCreator(HugeLongArray sortedByCommunity, HugeLongArray communities, Partition partition, RelationshipsBuilder relationshipsBuilder, RelationshipIterator relationshipIterator, Direction direction, ProgressTracker progressTracker) {
        this.direction = direction;
        this.relationshipsBuilder = relationshipsBuilder;
        this.communities = communities;
        this.relationshipIterator = relationshipIterator;
        this.partition = partition;
        this.progressTracker = progressTracker;
        this.encounteredCommunityWeights = HugeDoubleArray.newArray((long)communities.size());
        this.encounteredCommunities = HugeLongArray.newArray((long)communities.size());
        this.encounteredCommunityWeights.setAll(v -> -1.0);
        this.sortedByCommunity = sortedByCommunity;
    }

    private void updateRelationships(long sourceCommunityId, long numEncounteredCommunities) {
        for (long communityIndexId = 0L; communityIndexId < numEncounteredCommunities; ++communityIndexId) {
            long communityId = this.encounteredCommunities.get(communityIndexId);
            double weight = this.encounteredCommunityWeights.get(communityId);
            this.relationshipsBuilder.add(sourceCommunityId, communityId, weight);
            this.encounteredCommunityWeights.set(communityId, -1.0);
        }
    }

    @Override
    public void run() {
        long startNode = this.partition.startNode();
        long endNode = this.partition.startNode() + this.partition.nodeCount();
        long previousCommunity = -1L;
        for (long nodeIndexId = startNode; nodeIndexId < endNode; ++nodeIndexId) {
            boolean shouldUpdate;
            long nodeId = this.sortedByCommunity.get(nodeIndexId);
            long currentCommunity = this.communities.get(nodeId);
            boolean bl = shouldUpdate = nodeIndexId > startNode && previousCommunity != currentCommunity;
            if (shouldUpdate) {
                this.updateRelationships(previousCommunity, this.encountereCommunitiesCounter);
                this.encountereCommunitiesCounter = 0L;
            }
            this.relationshipIterator.forEachRelationship(nodeId, 1.0, (source, target, property) -> {
                long targetCommunityId = this.communities.get(target);
                if (currentCommunity != targetCommunityId && (this.direction == Direction.DIRECTED || currentCommunity > targetCommunityId)) {
                    double valueToAdd = property;
                    if (this.encounteredCommunityWeights.get(targetCommunityId) == -1.0) {
                        this.encounteredCommunities.set(this.encountereCommunitiesCounter++, targetCommunityId);
                        valueToAdd += 1.0;
                    }
                    this.encounteredCommunityWeights.addTo(targetCommunityId, valueToAdd);
                }
                return true;
            });
            boolean bl2 = shouldUpdate = nodeIndexId == endNode - 1L;
            if (shouldUpdate) {
                this.updateRelationships(currentCommunity, this.encountereCommunitiesCounter);
            }
            previousCommunity = currentCommunity;
            this.progressTracker.logProgress();
        }
    }
}

