/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.leiden;

import com.carrotsearch.hppc.cursors.LongLongCursor;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;

interface SeedCommunityManager {
    public long mapToSeed(long var1);

    public static SeedCommunityManager create(boolean isSeeded, HugeLongArray startingNodeCommunities) {
        if (!isSeeded) {
            return new EmptySeedCommunityManager();
        }
        return FullSeedCommunityManager.create(startingNodeCommunities);
    }

    public static MemoryEstimation memoryEstimation() {
        return MemoryEstimations.builder().perNode("seed map", HugeLongLongMap.memoryEstimation()).perNode("reverse seed map", HugeLongArray::memoryEstimation).build();
    }

    public static class FullSeedCommunityManager
    implements SeedCommunityManager {
        private HugeLongArray reverseMap;

        FullSeedCommunityManager(HugeLongArray reverseMap) {
            this.reverseMap = reverseMap;
        }

        static FullSeedCommunityManager create(HugeLongArray startingCommunities) {
            long nodeCount = startingCommunities.size();
            HugeLongLongMap seedMap = new HugeLongLongMap(nodeCount);
            long maxId = 0L;
            for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
                long communityId = startingCommunities.get(nodeId);
                if (!seedMap.containsKey(communityId)) {
                    maxId = nodeId;
                    seedMap.put(communityId, nodeId);
                }
                startingCommunities.set(nodeId, seedMap.getOrDefault(communityId, -1L));
            }
            HugeLongArray reverseMap = HugeLongArray.newArray((long)(maxId + 1L));
            for (LongLongCursor cursor : seedMap) {
                reverseMap.set(cursor.value, cursor.key);
            }
            return new FullSeedCommunityManager(reverseMap);
        }

        @Override
        public long mapToSeed(long communityId) {
            return this.reverseMap.get(communityId);
        }
    }

    public static class EmptySeedCommunityManager
    implements SeedCommunityManager {
        EmptySeedCommunityManager() {
        }

        @Override
        public long mapToSeed(long communityId) {
            return communityId;
        }
    }
}

