/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.louvain;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.NodesBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.OriginalIdNodePropertyValues;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.louvain.LouvainBaseConfig;
import org.neo4j.gds.louvain.LouvainDendrogramManager;
import org.neo4j.gds.modularityoptimization.ImmutableModularityOptimizationStreamConfig;
import org.neo4j.gds.modularityoptimization.ModularityOptimization;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationFactory;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationStreamConfig;

public final class Louvain
extends Algorithm<Louvain> {
    private final Graph rootGraph;
    private final NodePropertyValues seedingValues;
    private final ExecutorService executorService;
    private final LouvainDendrogramManager dendrogramManager;
    private double[] modularities;
    private int ranLevels;
    private final int maxLevels;
    private final int concurrency;
    private final int maxIterations;
    private final double tolerance;
    private final boolean trackIntermediateCommunities;

    public Louvain(Graph graph, LouvainBaseConfig config, boolean trackIntermediateCommunities, int maxLevels, int maxIterations, double tolerance, int concurrency, ProgressTracker progressTracker, ExecutorService executorService) {
        super(progressTracker);
        this.rootGraph = graph;
        this.maxIterations = maxIterations;
        this.concurrency = concurrency;
        this.seedingValues = Optional.ofNullable(config.seedProperty()).map(arg_0 -> ((Graph)graph).nodeProperties(arg_0)).orElse(null);
        this.executorService = executorService;
        this.dendrogramManager = new LouvainDendrogramManager(graph.nodeCount(), maxLevels, trackIntermediateCommunities);
        this.tolerance = tolerance;
        this.modularities = new double[maxLevels];
        this.maxLevels = maxLevels;
        this.trackIntermediateCommunities = trackIntermediateCommunities;
    }

    public Louvain compute() {
        this.progressTracker.beginSubTask();
        Graph workingGraph = this.rootGraph;
        Object nextSeedingValues = this.seedingValues;
        boolean resized = false;
        long oldNodeCount = this.rootGraph.nodeCount();
        this.ranLevels = 0;
        while (this.ranLevels < this.maxLevels) {
            this.terminationFlag.assertRunning();
            ModularityOptimization modularityOptimization = this.runModularityOptimization(workingGraph, (NodePropertyValues)nextSeedingValues);
            modularityOptimization.release();
            this.modularities[this.ranLevels] = modularityOptimization.getModularity();
            this.dendrogramManager.prepareNextLevel(this.ranLevels);
            long maxCommunityId = this.buildDendrogram(workingGraph, this.ranLevels, modularityOptimization);
            workingGraph = this.summarizeGraph(workingGraph, modularityOptimization, maxCommunityId);
            nextSeedingValues = new OriginalIdNodePropertyValues((IdMap)workingGraph){

                public OptionalLong getMaxLongPropertyValue() {
                    return OptionalLong.empty();
                }
            };
            if (workingGraph.nodeCount() == oldNodeCount || workingGraph.nodeCount() == 1L || this.hasConverged()) {
                resized = true;
                this.resizeResultArrays();
                break;
            }
            oldNodeCount = workingGraph.nodeCount();
            ++this.ranLevels;
        }
        if (!resized && !this.trackIntermediateCommunities) {
            this.resizeResultArrays();
        }
        this.progressTracker.endSubTask();
        return this;
    }

    private void resizeResultArrays() {
        int numLevels = this.levels();
        double[] resizedModularities = new double[numLevels];
        if (numLevels < this.maxLevels) {
            System.arraycopy(this.modularities, 0, resizedModularities, 0, numLevels);
            this.modularities = resizedModularities;
        }
        this.dendrogramManager.resizeDendrogram(numLevels);
    }

    private long buildDendrogram(Graph workingGraph, int level, ModularityOptimization modularityOptimization) {
        AtomicLong maxCommunityId = new AtomicLong(0L);
        ParallelUtil.parallelForEachNode((Graph)this.rootGraph, (int)this.concurrency, nodeId -> {
            long currentMaxId;
            boolean updatedMaxCurrentId;
            long prevId = level == 0 ? nodeId : workingGraph.toMappedNodeId(this.dendrogramManager.getPrevious(nodeId));
            long communityId = modularityOptimization.getCommunityId(prevId);
            while (!(updatedMaxCurrentId = communityId > (currentMaxId = maxCommunityId.get()) ? maxCommunityId.compareAndSet(currentMaxId, communityId) : true)) {
            }
            this.dendrogramManager.set(nodeId, communityId);
        });
        return maxCommunityId.get();
    }

    private ModularityOptimization runModularityOptimization(Graph louvainGraph, NodePropertyValues seed) {
        ModularityOptimizationStreamConfig modularityOptimizationConfig = ImmutableModularityOptimizationStreamConfig.builder().maxIterations(this.maxIterations).tolerance(this.tolerance).concurrency(this.concurrency).batchSize(10000).build();
        ModularityOptimization modularityOptimization = new ModularityOptimizationFactory<ModularityOptimizationStreamConfig>().build(louvainGraph, modularityOptimizationConfig, seed, this.progressTracker);
        modularityOptimization.setTerminationFlag(this.terminationFlag);
        modularityOptimization.compute();
        return modularityOptimization;
    }

    private Graph summarizeGraph(Graph workingGraph, ModularityOptimization modularityOptimization, long maxCommunityId) {
        NodesBuilder nodesBuilder = GraphFactory.initNodesBuilder().maxOriginalId(maxCommunityId).concurrency(this.concurrency).build();
        this.terminationFlag.assertRunning();
        workingGraph.forEachNode(nodeId -> {
            nodesBuilder.addNode(modularityOptimization.getCommunityId(nodeId));
            return true;
        });
        this.terminationFlag.assertRunning();
        IdMap idMap = nodesBuilder.build().idMap();
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)idMap).relationshipType(RelationshipType.of((String)"IGNORED")).orientation(this.rootGraph.schema().direction().toOrientation()).addPropertyConfig(GraphFactory.PropertyConfig.builder().propertyKey("property").aggregation(Aggregation.SUM).build()).executorService(this.executorService).build();
        List relationshipCreators = PartitionUtils.rangePartition((int)this.concurrency, (long)workingGraph.nodeCount(), partition -> new RelationshipCreator(relationshipsBuilder, modularityOptimization, (RelationshipIterator)workingGraph.concurrentCopy(), (Partition)partition), Optional.empty());
        ParallelUtil.run((Collection)relationshipCreators, (ExecutorService)this.executorService);
        return GraphFactory.create((IdMap)idMap, (SingleTypeRelationships)relationshipsBuilder.build());
    }

    private boolean hasConverged() {
        if (this.ranLevels == 0) {
            return false;
        }
        double currentModularity = this.modularities[this.ranLevels];
        double previousModularity = this.modularities[this.ranLevels - 1];
        return !(currentModularity > previousModularity) || !(Math.abs(currentModularity - previousModularity) > this.tolerance);
    }

    public HugeLongArray[] dendrograms() {
        return this.dendrogramManager.getAllDendrograms();
    }

    public HugeLongArray finalDendrogram() {
        return this.dendrogramManager.getCurrent();
    }

    public long getCommunity(long nodeId) {
        return this.dendrogramManager.getCommunity(nodeId);
    }

    public long[] getCommunities(long nodeId) {
        return this.dendrogramManager.getIntermediateCommunitiesForNode(nodeId);
    }

    public int levels() {
        return this.ranLevels == 0 ? 1 : this.ranLevels;
    }

    public double[] modularities() {
        return this.modularities;
    }

    public void release() {
        this.rootGraph.releaseTopology();
    }

    static final class RelationshipCreator
    implements Runnable {
        private final RelationshipsBuilder relationshipsBuilder;
        private final ModularityOptimization modularityOptimization;
        private final RelationshipIterator relationshipIterator;
        private final Partition partition;

        private RelationshipCreator(RelationshipsBuilder relationshipsBuilder, ModularityOptimization modularityOptimization, RelationshipIterator relationshipIterator, Partition partition) {
            this.relationshipsBuilder = relationshipsBuilder;
            this.modularityOptimization = modularityOptimization;
            this.relationshipIterator = relationshipIterator;
            this.partition = partition;
        }

        @Override
        public void run() {
            this.partition.consume(nodeId -> {
                long communityId = this.modularityOptimization.getCommunityId(nodeId);
                this.relationshipIterator.forEachRelationship(nodeId, 1.0, (source, target, property) -> {
                    this.relationshipsBuilder.add(communityId, this.modularityOptimization.getCommunityId(target), property);
                    return true;
                });
            });
        }
    }
}

