/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.louvain;

import org.neo4j.gds.core.utils.paged.HugeLongArray;

public class LouvainDendrogramManager {
    private HugeLongArray[] dendrograms;
    private final long nodeCount;
    private final int maxLevels;
    private final boolean trackIntermediateCommunities;
    private int currentIndex;
    private int previousIndex;

    public LouvainDendrogramManager(long nodeCount, int maxLevels, boolean trackIntermediateCommunities) {
        this.dendrograms = trackIntermediateCommunities ? new HugeLongArray[maxLevels] : new HugeLongArray[Math.min(maxLevels, 2)];
        this.nodeCount = nodeCount;
        this.trackIntermediateCommunities = trackIntermediateCommunities;
        this.maxLevels = maxLevels;
    }

    public HugeLongArray[] getAllDendrograms() {
        return this.dendrograms;
    }

    public void prepareNextLevel(int ranLevels) {
        int n = this.currentIndex = this.trackIntermediateCommunities ? ranLevels : ranLevels % 2;
        if (this.currentIndex > 1 || ranLevels <= 1) {
            this.dendrograms[this.currentIndex] = HugeLongArray.newArray((long)this.nodeCount);
        }
        this.previousIndex = this.trackIntermediateCommunities ? ranLevels - 1 : (1 + ranLevels) % 2;
    }

    public void set(long nodeId, long communityId) {
        this.dendrograms[this.currentIndex].set(nodeId, communityId);
    }

    public HugeLongArray getCurrent() {
        return this.dendrograms[this.currentIndex];
    }

    public long getCommunity(long nodeId) {
        return this.dendrograms[this.currentIndex].get(nodeId);
    }

    public long getPrevious(long nodeId) {
        return this.dendrograms[this.previousIndex].get(nodeId);
    }

    public long[] getIntermediateCommunitiesForNode(long nodeId) {
        long[] communities = new long[this.dendrograms.length];
        for (int i = 0; i < this.dendrograms.length; ++i) {
            communities[i] = this.dendrograms[i].get(nodeId);
        }
        return communities;
    }

    public void resizeDendrogram(int numLevels) {
        if (this.trackIntermediateCommunities) {
            HugeLongArray[] resizedDendrogram = new HugeLongArray[numLevels];
            if (numLevels < this.maxLevels) {
                System.arraycopy(this.dendrograms, 0, resizedDendrogram, 0, numLevels);
                this.dendrograms = resizedDendrogram;
            }
            this.currentIndex = numLevels - 1;
        } else {
            this.currentIndex = (1 + numLevels) % 2;
        }
    }
}

