/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.louvain;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.ImmutableRelationshipProjections;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.loading.NativeFactory;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.louvain.Louvain;
import org.neo4j.gds.louvain.LouvainBaseConfig;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationFactory;

public class LouvainFactory<CONFIG extends LouvainBaseConfig>
extends GraphAlgorithmFactory<Louvain, CONFIG> {
    public String taskName() {
        return "Louvain";
    }

    public Louvain build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return new Louvain(graph, (LouvainBaseConfig)configuration, configuration.includeIntermediateCommunities(), configuration.maxLevels(), configuration.maxIterations(), configuration.tolerance(), configuration.concurrency(), progressTracker, Pools.DEFAULT);
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return MemoryEstimations.builder(Louvain.class).add("modularityOptimization()", ModularityOptimizationFactory.MEMORY_ESTIMATION).rangePerGraphDimension("subGraph", (graphDimensions, concurrency) -> {
            ImmutableGraphDimensions.Builder dimensionsBuilder = ImmutableGraphDimensions.builder().from(graphDimensions);
            GraphDimensions sparseDimensions = dimensionsBuilder.build();
            RelationshipProjections relationshipProjections = ImmutableRelationshipProjections.builder().putProjection(RelationshipType.of((String)"AGGREGATE"), ((RelationshipProjection.Builder)RelationshipProjection.builder().type("AGGREGATE").orientation(Orientation.UNDIRECTED).aggregation(Aggregation.SUM).addProperty("prop", "prop", DefaultValue.of((Object)0.0))).build()).build();
            long maxGraphSize = NativeFactory.getMemoryEstimation((NodeProjections)NodeProjections.all(), (RelationshipProjections)relationshipProjections, (boolean)false).estimate((GraphDimensions)sparseDimensions, (int)concurrency.intValue()).memoryUsage().max;
            return MemoryRange.of((long)1L, (long)maxGraphSize);
        }).rangePerNode("dendrograms", nodeCount -> MemoryRange.of((long)HugeLongArray.memoryEstimation((long)nodeCount), (long)(HugeLongArray.memoryEstimation((long)nodeCount) * (long)(config.includeIntermediateCommunities() ? config.maxLevels() : Math.min(2, config.maxLevels()))))).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.iterativeDynamic((String)this.taskName(), () -> List.of(ModularityOptimizationFactory.modularityOptimizationProgressTask(graph, config)), (int)config.maxLevels());
    }
}

