/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.louvain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.SeedConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.louvain.LouvainMutateConfig;

public final class LouvainMutateConfigImpl
implements LouvainMutateConfig {
    private double tolerance;
    private int maxIterations;
    private int maxLevels;
    private boolean includeIntermediateCommunities;
    private List<String> relationshipTypes;
    private List<String> nodeLabels;
    private Optional<String> usernameOverride;
    private boolean sudo;
    private boolean logProgress;
    private int concurrency;
    private JobId jobId;
    @Nullable
    private String seedProperty;
    private boolean consecutiveIds;
    private Optional<String> relationshipWeightProperty;
    private String mutateProperty;

    public LouvainMutateConfigImpl(@NotNull CypherMapAccess config) {
        ArrayList<IllegalArgumentException> errors = new ArrayList<IllegalArgumentException>();
        try {
            this.tolerance = config.getDouble("tolerance", LouvainMutateConfig.super.tolerance());
            CypherMapAccess.validateDoubleRange((String)"tolerance", (double)this.tolerance, (double)0.0, (double)Double.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxIterations = config.getInt("maxIterations", LouvainMutateConfig.super.maxIterations());
            CypherMapAccess.validateIntegerRange((String)"maxIterations", (int)this.maxIterations, (int)1, (int)Integer.MAX_VALUE, (boolean)true, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.maxLevels = config.getInt("maxLevels", LouvainMutateConfig.super.maxLevels());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.includeIntermediateCommunities = config.getBool("includeIntermediateCommunities", LouvainMutateConfig.super.includeIntermediateCommunities());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipTypes = (List)CypherMapAccess.failOnNull((String)"relationshipTypes", (Object)((List)config.getChecked("relationshipTypes", (Object)LouvainMutateConfig.super.relationshipTypes(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.nodeLabels = (List)CypherMapAccess.failOnNull((String)"nodeLabels", (Object)((List)config.getChecked("nodeLabels", (Object)LouvainMutateConfig.super.nodeLabels(), List.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.usernameOverride = (Optional)CypherMapAccess.failOnNull((String)"username", config.getOptional("username", String.class).map(BaseConfig::trim));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.sudo = config.getBool("sudo", LouvainMutateConfig.super.sudo());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.logProgress = config.getBool("logProgress", LouvainMutateConfig.super.logProgress());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.concurrency = config.getInt("concurrency", LouvainMutateConfig.super.concurrency());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.jobId = (JobId)CypherMapAccess.failOnNull((String)"jobId", (Object)JobId.parse((Object)config.getChecked("jobId", (Object)LouvainMutateConfig.super.jobId(), Object.class)));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.seedProperty = SeedConfig.validatePropertyName((String)config.getString("seedProperty", LouvainMutateConfig.super.seedProperty()));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.consecutiveIds = config.getBool("consecutiveIds", LouvainMutateConfig.super.consecutiveIds());
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.relationshipWeightProperty = (Optional)CypherMapAccess.failOnNull((String)"relationshipWeightProperty", (Object)config.getOptional("relationshipWeightProperty", String.class));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.mutateProperty = (String)CypherMapAccess.failOnNull((String)"mutateProperty", (Object)MutatePropertyConfig.validateProperty((String)config.requireString("mutateProperty")));
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        try {
            this.validate();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateConcurrency();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.forbidSeedingAndConsecutiveIds();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            this.validateRelationshipWeightProperty();
        }
        catch (IllegalArgumentException e) {
            errors.add(e);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            if (errors.size() == 1) {
                throw (IllegalArgumentException)errors.get(0);
            }
            String combinedErrorMsg = errors.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError = new IllegalArgumentException(combinedErrorMsg);
            errors.forEach(error -> combinedError.addSuppressed((Throwable)error));
            throw combinedError;
        }
    }

    @Override
    public double tolerance() {
        return this.tolerance;
    }

    @Override
    public int maxIterations() {
        return this.maxIterations;
    }

    @Override
    public int maxLevels() {
        return this.maxLevels;
    }

    @Override
    public boolean includeIntermediateCommunities() {
        return this.includeIntermediateCommunities;
    }

    public List<String> relationshipTypes() {
        return this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        return this.nodeLabels;
    }

    public void graphStoreValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        ArrayList<IllegalArgumentException> errors_ = new ArrayList<IllegalArgumentException>();
        try {
            this.validateNodeLabels(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateRelationshipTypes(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateSeedProperty(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.relationshipWeightValidation(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        try {
            this.validateMutateProperty(graphStore, selectedLabels, selectedRelationshipTypes);
        }
        catch (IllegalArgumentException e) {
            errors_.add(e);
        }
        if (!errors_.isEmpty()) {
            if (errors_.size() == 1) {
                throw (IllegalArgumentException)errors_.get(0);
            }
            String combinedErrorMsg_ = errors_.stream().map(Throwable::getMessage).collect(Collectors.joining(System.lineSeparator() + "\t\t\t\t", "Multiple errors in configuration arguments:" + System.lineSeparator() + "\t\t\t\t", ""));
            IllegalArgumentException combinedError_ = new IllegalArgumentException(combinedErrorMsg_);
            errors_.forEach(error_ -> combinedError_.addSuppressed((Throwable)error_));
            throw combinedError_;
        }
    }

    public Optional<String> usernameOverride() {
        return this.usernameOverride;
    }

    public boolean sudo() {
        return this.sudo;
    }

    public boolean logProgress() {
        return this.logProgress;
    }

    public Collection<String> configKeys() {
        return Arrays.asList("tolerance", "maxIterations", "maxLevels", "includeIntermediateCommunities", "relationshipTypes", "nodeLabels", "username", "sudo", "logProgress", "concurrency", "jobId", "seedProperty", "consecutiveIds", "relationshipWeightProperty", "mutateProperty");
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("tolerance", this.tolerance());
        map.put("maxIterations", this.maxIterations());
        map.put("maxLevels", this.maxLevels());
        map.put("includeIntermediateCommunities", this.includeIntermediateCommunities());
        map.put("relationshipTypes", this.relationshipTypes());
        map.put("nodeLabels", this.nodeLabels());
        this.usernameOverride().ifPresent(username -> map.put("username", username));
        map.put("sudo", this.sudo());
        map.put("logProgress", this.logProgress());
        map.put("concurrency", this.concurrency());
        map.put("jobId", JobId.asString((JobId)this.jobId()));
        map.put("seedProperty", this.seedProperty());
        map.put("consecutiveIds", this.consecutiveIds());
        this.relationshipWeightProperty().ifPresent(relationshipWeightProperty -> map.put("relationshipWeightProperty", relationshipWeightProperty));
        map.put("mutateProperty", this.mutateProperty());
        return map;
    }

    public int concurrency() {
        return this.concurrency;
    }

    public JobId jobId() {
        return this.jobId;
    }

    @Nullable
    public String seedProperty() {
        return this.seedProperty;
    }

    public boolean consecutiveIds() {
        return this.consecutiveIds;
    }

    public Optional<String> relationshipWeightProperty() {
        return this.relationshipWeightProperty;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Object> config = new HashMap<String, Object>();

        public static Builder from(LouvainMutateConfig baseConfig) {
            Builder builder = new Builder();
            builder.tolerance(baseConfig.tolerance());
            builder.maxIterations(baseConfig.maxIterations());
            builder.maxLevels(baseConfig.maxLevels());
            builder.includeIntermediateCommunities(baseConfig.includeIntermediateCommunities());
            builder.relationshipTypes(baseConfig.relationshipTypes());
            builder.nodeLabels(baseConfig.nodeLabels());
            builder.usernameOverride(baseConfig.usernameOverride());
            builder.sudo(baseConfig.sudo());
            builder.logProgress(baseConfig.logProgress());
            builder.concurrency(baseConfig.concurrency());
            builder.jobId(baseConfig.jobId());
            builder.seedProperty(baseConfig.seedProperty());
            builder.consecutiveIds(baseConfig.consecutiveIds());
            builder.relationshipWeightProperty(baseConfig.relationshipWeightProperty());
            builder.mutateProperty(baseConfig.mutateProperty());
            return builder;
        }

        public Builder tolerance(double tolerance) {
            this.config.put("tolerance", tolerance);
            return this;
        }

        public Builder maxIterations(int maxIterations) {
            this.config.put("maxIterations", maxIterations);
            return this;
        }

        public Builder maxLevels(int maxLevels) {
            this.config.put("maxLevels", maxLevels);
            return this;
        }

        public Builder includeIntermediateCommunities(boolean includeIntermediateCommunities) {
            this.config.put("includeIntermediateCommunities", includeIntermediateCommunities);
            return this;
        }

        public Builder relationshipTypes(List<String> relationshipTypes) {
            this.config.put("relationshipTypes", relationshipTypes);
            return this;
        }

        public Builder nodeLabels(List<String> nodeLabels) {
            this.config.put("nodeLabels", nodeLabels);
            return this;
        }

        public Builder usernameOverride(String usernameOverride) {
            this.config.put("username", usernameOverride);
            return this;
        }

        public Builder usernameOverride(Optional<String> usernameOverride) {
            usernameOverride.ifPresent(actualusernameOverride -> this.config.put("username", actualusernameOverride));
            return this;
        }

        public Builder sudo(boolean sudo) {
            this.config.put("sudo", sudo);
            return this;
        }

        public Builder logProgress(boolean logProgress) {
            this.config.put("logProgress", logProgress);
            return this;
        }

        public Builder concurrency(int concurrency) {
            this.config.put("concurrency", concurrency);
            return this;
        }

        public Builder jobId(Object jobId) {
            this.config.put("jobId", jobId);
            return this;
        }

        public Builder seedProperty(String seedProperty) {
            this.config.put("seedProperty", seedProperty);
            return this;
        }

        public Builder consecutiveIds(boolean consecutiveIds) {
            this.config.put("consecutiveIds", consecutiveIds);
            return this;
        }

        public Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.config.put("relationshipWeightProperty", relationshipWeightProperty);
            return this;
        }

        public Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            relationshipWeightProperty.ifPresent(actualrelationshipWeightProperty -> this.config.put("relationshipWeightProperty", actualrelationshipWeightProperty));
            return this;
        }

        public Builder mutateProperty(String mutateProperty) {
            this.config.put("mutateProperty", mutateProperty);
            return this;
        }

        public LouvainMutateConfig build() {
            CypherMapWrapper config = CypherMapWrapper.create(this.config);
            return new LouvainMutateConfigImpl((CypherMapAccess)config);
        }
    }
}

