/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.modularity.CommunityModularity;

@Generated(from="CommunityModularity", generator="Immutables")
public final class ImmutableCommunityModularity
implements CommunityModularity {
    private final long communityId;
    private final double modularity;

    private ImmutableCommunityModularity(long communityId, double modularity) {
        this.communityId = communityId;
        this.modularity = modularity;
    }

    @Override
    public long communityId() {
        return this.communityId;
    }

    @Override
    public double modularity() {
        return this.modularity;
    }

    public final ImmutableCommunityModularity withCommunityId(long value) {
        if (this.communityId == value) {
            return this;
        }
        return new ImmutableCommunityModularity(value, this.modularity);
    }

    public final ImmutableCommunityModularity withModularity(double value) {
        if (Double.doubleToLongBits(this.modularity) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableCommunityModularity(this.communityId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommunityModularity && this.equalTo((ImmutableCommunityModularity)another);
    }

    private boolean equalTo(ImmutableCommunityModularity another) {
        return this.communityId == another.communityId && Double.doubleToLongBits(this.modularity) == Double.doubleToLongBits(another.modularity);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.communityId);
        h += (h << 5) + Double.hashCode(this.modularity);
        return h;
    }

    public String toString() {
        return "CommunityModularity{communityId=" + this.communityId + ", modularity=" + this.modularity + "}";
    }

    public static CommunityModularity of(long communityId, double modularity) {
        return new ImmutableCommunityModularity(communityId, modularity);
    }

    public static CommunityModularity copyOf(CommunityModularity instance) {
        if (instance instanceof ImmutableCommunityModularity) {
            return (ImmutableCommunityModularity)instance;
        }
        return ImmutableCommunityModularity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommunityModularity", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_COMMUNITY_ID = 1L;
        private static final long INIT_BIT_MODULARITY = 2L;
        private long initBits = 3L;
        private long communityId;
        private double modularity;

        private Builder() {
        }

        public final Builder from(CommunityModularity instance) {
            Objects.requireNonNull(instance, "instance");
            this.communityId(instance.communityId());
            this.modularity(instance.modularity());
            return this;
        }

        public final Builder communityId(long communityId) {
            this.communityId = communityId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder modularity(double modularity) {
            this.modularity = modularity;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Builder clear() {
            this.initBits = 3L;
            this.communityId = 0L;
            this.modularity = 0.0;
            return this;
        }

        public CommunityModularity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommunityModularity(this.communityId, this.modularity);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("communityId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("modularity");
            }
            return "Cannot build CommunityModularity, some of required attributes are not set " + attributes;
        }
    }
}

