/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.modularity.CommunityModularity;
import org.neo4j.gds.modularity.ModularityResult;

@Generated(from="ModularityResult", generator="Immutables")
public final class ImmutableModularityResult
implements ModularityResult {
    private final double totalModularity;
    private final long communityCount;
    private final HugeObjectArray<CommunityModularity> modularityScores;

    private ImmutableModularityResult(double totalModularity, long communityCount, HugeObjectArray<CommunityModularity> modularityScores) {
        this.totalModularity = totalModularity;
        this.communityCount = communityCount;
        this.modularityScores = Objects.requireNonNull(modularityScores, "modularityScores");
    }

    private ImmutableModularityResult(ImmutableModularityResult original, double totalModularity, long communityCount, HugeObjectArray<CommunityModularity> modularityScores) {
        this.totalModularity = totalModularity;
        this.communityCount = communityCount;
        this.modularityScores = modularityScores;
    }

    @Override
    public double totalModularity() {
        return this.totalModularity;
    }

    @Override
    public long communityCount() {
        return this.communityCount;
    }

    @Override
    public HugeObjectArray<CommunityModularity> modularityScores() {
        return this.modularityScores;
    }

    public final ImmutableModularityResult withTotalModularity(double value) {
        if (Double.doubleToLongBits(this.totalModularity) == Double.doubleToLongBits(value)) {
            return this;
        }
        return new ImmutableModularityResult(this, value, this.communityCount, this.modularityScores);
    }

    public final ImmutableModularityResult withCommunityCount(long value) {
        if (this.communityCount == value) {
            return this;
        }
        return new ImmutableModularityResult(this, this.totalModularity, value, this.modularityScores);
    }

    public final ImmutableModularityResult withModularityScores(HugeObjectArray<CommunityModularity> value) {
        if (this.modularityScores == value) {
            return this;
        }
        HugeObjectArray<CommunityModularity> newValue = Objects.requireNonNull(value, "modularityScores");
        return new ImmutableModularityResult(this, this.totalModularity, this.communityCount, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableModularityResult && this.equalTo((ImmutableModularityResult)another);
    }

    private boolean equalTo(ImmutableModularityResult another) {
        return Double.doubleToLongBits(this.totalModularity) == Double.doubleToLongBits(another.totalModularity) && this.communityCount == another.communityCount && this.modularityScores.equals(another.modularityScores);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Double.hashCode(this.totalModularity);
        h += (h << 5) + Long.hashCode(this.communityCount);
        h += (h << 5) + this.modularityScores.hashCode();
        return h;
    }

    public String toString() {
        return "ModularityResult{totalModularity=" + this.totalModularity + ", communityCount=" + this.communityCount + ", modularityScores=" + this.modularityScores + "}";
    }

    public static ModularityResult of(double totalModularity, long communityCount, HugeObjectArray<CommunityModularity> modularityScores) {
        return new ImmutableModularityResult(totalModularity, communityCount, modularityScores);
    }

    public static ModularityResult copyOf(ModularityResult instance) {
        if (instance instanceof ImmutableModularityResult) {
            return (ImmutableModularityResult)instance;
        }
        return ImmutableModularityResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ModularityResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_TOTAL_MODULARITY = 1L;
        private static final long INIT_BIT_COMMUNITY_COUNT = 2L;
        private static final long INIT_BIT_MODULARITY_SCORES = 4L;
        private long initBits = 7L;
        private double totalModularity;
        private long communityCount;
        private HugeObjectArray<CommunityModularity> modularityScores;

        private Builder() {
        }

        public final Builder from(ModularityResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.totalModularity(instance.totalModularity());
            this.communityCount(instance.communityCount());
            this.modularityScores(instance.modularityScores());
            return this;
        }

        public final Builder totalModularity(double totalModularity) {
            this.totalModularity = totalModularity;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder communityCount(long communityCount) {
            this.communityCount = communityCount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder modularityScores(HugeObjectArray<CommunityModularity> modularityScores) {
            this.modularityScores = Objects.requireNonNull(modularityScores, "modularityScores");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Builder clear() {
            this.initBits = 7L;
            this.totalModularity = 0.0;
            this.communityCount = 0L;
            this.modularityScores = null;
            return this;
        }

        public ModularityResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableModularityResult(null, this.totalModularity, this.communityCount, this.modularityScores);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("totalModularity");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("communityCount");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("modularityScores");
            }
            return "Cannot build ModularityResult, some of required attributes are not set " + attributes;
        }
    }
}

