/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.Collection;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

@Configuration
public interface ModularityBaseConfig
extends AlgoBaseConfig,
RelationshipWeightConfig {
    @Configuration.ConvertWith(method="validatePropertyName")
    public String communityProperty();

    @Nullable
    public static String validatePropertyName(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)StringIdentifierValidations.emptyToNull((String)input), (String)"communityProperty");
    }

    @Configuration.GraphStoreValidationCheck
    @Configuration.Ignore
    default public void communityPropertyValidation(GraphStore graphStore, Collection<NodeLabel> selectedLabels, Collection<RelationshipType> selectedRelationshipTypes) {
        if (selectedLabels.stream().anyMatch(label -> graphStore.nodePropertyKeys(label).contains(this.communityProperty()))) {
            return;
        }
        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"communityProperty `%s` is not present for any requested node labels. Requested labels: %s. Labels with `%1$s` present: %s", (Object[])new Object[]{this.communityProperty(), StringJoining.join(selectedLabels.stream().map(ElementIdentifier::name)), StringJoining.join(graphStore.nodeLabels().stream().filter(label -> graphStore.nodePropertyKeys(label).contains(this.communityProperty())).map(ElementIdentifier::name))}));
    }
}

