/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import com.carrotsearch.hppc.cursors.LongLongCursor;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.LongUnaryOperator;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.modularity.CommunityModularity;
import org.neo4j.gds.modularity.ModularityResult;
import org.neo4j.gds.modularity.RelationshipCountCollector;

public class ModularityCalculator
extends Algorithm<ModularityResult> {
    private final Graph graph;
    private final LongUnaryOperator communityIdProvider;
    private final HugeLongLongMap communityMapper;
    private final int concurrency;

    public static ModularityCalculator create(Graph graph, LongUnaryOperator seedCommunityIdProvider, int concurrency) {
        HugeLongLongMap communityMapper = ModularityCalculator.createMapping(graph.nodeCount(), seedCommunityIdProvider);
        LongUnaryOperator communityIdProvider = nodeId -> communityMapper.getOrDefault(seedCommunityIdProvider.applyAsLong(nodeId), -1L);
        return new ModularityCalculator(graph, communityIdProvider, communityMapper, concurrency);
    }

    private ModularityCalculator(Graph graph, LongUnaryOperator communityIdProvider, HugeLongLongMap communityMapper, int concurrency) {
        super(ProgressTracker.NULL_TRACKER);
        this.graph = graph;
        this.communityIdProvider = communityIdProvider;
        this.communityMapper = communityMapper;
        this.concurrency = concurrency;
    }

    public ModularityResult compute() {
        long nodeCount = this.graph.nodeCount();
        long communityCount = this.communityMapper.size();
        HugeAtomicDoubleArray insideRelationships = HugeAtomicDoubleArray.newArray((long)communityCount);
        HugeAtomicDoubleArray totalCommunityRelationships = HugeAtomicDoubleArray.newArray((long)communityCount);
        DoubleAdder totalRelationshipWeight = new DoubleAdder();
        List tasks = PartitionUtils.rangePartition((int)this.concurrency, (long)nodeCount, partition -> new RelationshipCountCollector((Partition)partition, this.graph, insideRelationships, totalCommunityRelationships, this.communityIdProvider, totalRelationshipWeight), Optional.empty());
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)tasks).run();
        HugeObjectArray communityModularities = HugeObjectArray.newArray(CommunityModularity.class, (long)communityCount);
        double totalRelWeight = totalRelationshipWeight.doubleValue();
        MutableDouble totalModularity = new MutableDouble();
        long resultIndex = 0L;
        for (LongLongCursor cursor : this.communityMapper) {
            long communityId = cursor.key;
            long mappedCommunityId = cursor.value;
            double ec = insideRelationships.get(mappedCommunityId);
            double Kc = totalCommunityRelationships.get(mappedCommunityId);
            double modularity = (ec - Kc * Kc * (1.0 / totalRelWeight)) / totalRelWeight;
            totalModularity.add(modularity);
            communityModularities.set(resultIndex++, (Object)CommunityModularity.of(communityId, modularity));
        }
        return ModularityResult.of(totalModularity.doubleValue(), communityCount, (HugeObjectArray<CommunityModularity>)communityModularities);
    }

    public void release() {
    }

    static HugeLongLongMap createMapping(long nodeCount, LongUnaryOperator seedCommunityId) {
        HugeLongLongMap seedMap = new HugeLongLongMap(nodeCount);
        long seedId = 0L;
        for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
            long communityId = seedCommunityId.applyAsLong(nodeId);
            if (seedMap.containsKey(communityId)) continue;
            seedMap.put(communityId, seedId++);
        }
        return seedMap;
    }
}

