/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularity;

import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.LongUnaryOperator;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.partition.Partition;

class RelationshipCountCollector
implements Runnable {
    private final Partition partition;
    private final Graph localGraph;
    private final HugeAtomicDoubleArray insideRelationships;
    private final HugeAtomicDoubleArray totalCommunityRelationships;
    private final LongUnaryOperator communityIdProvider;
    private final DoubleAdder totalRelationshipWeight;

    RelationshipCountCollector(Partition partition, Graph graph, HugeAtomicDoubleArray insideRelationships, HugeAtomicDoubleArray totalCommunityRelationships, LongUnaryOperator communityIdProvider, DoubleAdder totalRelationshipWeight) {
        this.totalRelationshipWeight = totalRelationshipWeight;
        assert (insideRelationships.size() == totalCommunityRelationships.size());
        this.partition = partition;
        this.localGraph = graph.concurrentCopy();
        this.insideRelationships = insideRelationships;
        this.totalCommunityRelationships = totalCommunityRelationships;
        this.communityIdProvider = communityIdProvider;
    }

    @Override
    public void run() {
        long startNode = this.partition.startNode();
        long endNode = startNode + this.partition.nodeCount();
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            long communityId = this.communityIdProvider.applyAsLong(nodeId);
            this.localGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                long tCommunityId = this.communityIdProvider.applyAsLong(t);
                if (tCommunityId == communityId) {
                    this.insideRelationships.getAndAdd(communityId, w);
                }
                this.totalCommunityRelationships.getAndAdd(communityId, w);
                this.totalRelationshipWeight.add(w);
                return true;
            });
        }
    }
}

