/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;

class InsideRelationshipCalculator
implements Runnable {
    private final Partition partition;
    private final Graph localGraph;
    private final HugeAtomicDoubleArray insideRelationships;
    private final HugeLongArray communities;

    InsideRelationshipCalculator(Partition partition, Graph graph, HugeAtomicDoubleArray insideRelationships, HugeLongArray communities) {
        this.partition = partition;
        this.localGraph = graph.concurrentCopy();
        this.insideRelationships = insideRelationships;
        this.communities = communities;
    }

    @Override
    public void run() {
        long startNode = this.partition.startNode();
        long endNode = startNode + this.partition.nodeCount();
        for (long nodeId = startNode; nodeId < endNode; ++nodeId) {
            long communityId = this.communities.get(nodeId);
            this.localGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                long tCommunityId = this.communities.get(t);
                if (tCommunityId == communityId) {
                    this.insideRelationships.getAndAdd(communityId, w);
                }
                return true;
            });
        }
    }
}

