/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.LongLongHashMap;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

final class ModularityColorArray {
    private final HugeLongArray sortedNodesByColor;
    private BitSet colorCoordinates;
    private final long numberOfColors;

    private ModularityColorArray(HugeLongArray sortedNodesByColor, BitSet colorCoordinates) {
        this.colorCoordinates = colorCoordinates;
        this.sortedNodesByColor = sortedNodesByColor;
        this.numberOfColors = colorCoordinates.cardinality() - 1L;
    }

    long numberOfColors() {
        return this.numberOfColors;
    }

    long nextStartingCoordinate(long currentStartingPosition) {
        return this.colorCoordinates.nextSetBit(currentStartingPosition + 1L);
    }

    long nodeAtPosition(long indexId) {
        return this.sortedNodesByColor.get(indexId);
    }

    void release() {
        this.sortedNodesByColor.release();
        this.colorCoordinates = null;
    }

    static ModularityColorArray create(HugeLongArray colors, BitSet usedColors) {
        long nodeCount = colors.size();
        HugeLongArray sortedNodesByColor = HugeLongArray.newArray((long)nodeCount);
        HugeLongArray colorCoordinateArray = HugeLongArray.newArray((long)usedColors.cardinality());
        LongLongHashMap colorToId = new LongLongHashMap();
        long encounteredColors = 0L;
        BitSet setColorCoordinates = new BitSet(nodeCount + 1L);
        long nextColorId = usedColors.nextSetBit(0);
        while (nextColorId != -1L) {
            colorToId.put(nextColorId, encounteredColors++);
            nextColorId = usedColors.nextSetBit(nextColorId + 1L);
        }
        for (long nodeId = 0L; nodeId < nodeCount; ++nodeId) {
            long color = colors.get(nodeId);
            long colorId = colorToId.get(color);
            colorCoordinateArray.addTo(colorId, 1L);
        }
        setColorCoordinates.set(0L);
        long nodeSum = 0L;
        for (long colorId = 0L; colorId <= encounteredColors; ++colorId) {
            if (colorId == encounteredColors) {
                setColorCoordinates.set(nodeCount);
                continue;
            }
            colorCoordinateArray.set(colorId, nodeSum += colorCoordinateArray.get(colorId));
            setColorCoordinates.set(nodeSum);
        }
        for (long nodeId = nodeCount - 1L; nodeId >= 0L; --nodeId) {
            long color = colors.get(nodeId);
            long colorId = colorToId.get(color);
            long coordinate = colorCoordinateArray.get(colorId) - 1L;
            sortedNodesByColor.set(coordinate, nodeId);
            colorCoordinateArray.set(colorId, coordinate);
        }
        return new ModularityColorArray(sortedNodesByColor, setColorCoordinates);
    }
}

