/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import java.util.List;
import java.util.Optional;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.modularityoptimization.InsideRelationshipCalculator;

final class ModularityManager {
    private final Graph graph;
    private double totalWeight;
    private final HugeAtomicDoubleArray communityWeights;
    private HugeLongArray communities;
    private final int concurrency;

    static ModularityManager create(Graph graph, int concurrency) {
        return new ModularityManager(graph, HugeAtomicDoubleArray.newArray((long)graph.nodeCount()), concurrency);
    }

    private ModularityManager(Graph graph, HugeAtomicDoubleArray communityWeights, int concurrency) {
        this.graph = graph;
        this.communityWeights = communityWeights;
        this.concurrency = concurrency;
    }

    double calculateModularity() {
        HugeAtomicDoubleArray insideRelationships = HugeAtomicDoubleArray.newArray((long)this.graph.nodeCount());
        List tasks = PartitionUtils.rangePartition((int)this.concurrency, (long)this.graph.nodeCount(), partition -> new InsideRelationshipCalculator((Partition)partition, this.graph, insideRelationships, this.communities), Optional.empty());
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks((Iterable)tasks).run();
        double modularity = (Double)ParallelUtil.parallelStream((BaseStream)LongStream.range(0L, this.graph.nodeCount()), (int)this.concurrency, nodeStream -> nodeStream.mapToDouble(communityId -> {
            double ec = insideRelationships.get(communityId);
            double Kc = this.communityWeights.get(communityId);
            return ec - Kc * Kc * (1.0 / this.totalWeight);
        }).reduce(Double::sum).orElseThrow(() -> new RuntimeException("Error while computing modularity")));
        return modularity * (1.0 / this.totalWeight);
    }

    void totalWeight(double totalWeight) {
        this.totalWeight = totalWeight;
    }

    void communityWeightUpdate(long communityId, double weight) {
        this.communityWeights.update(communityId, agg -> agg + weight);
    }

    double getCommunityWeight(long communityId) {
        return this.communityWeights.get(communityId);
    }

    void registerCommunities(HugeLongArray communities) {
        this.communities = communities;
    }
}

