/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import com.carrotsearch.hppc.cursors.LongLongCursor;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.stream.BaseStream;
import java.util.stream.LongStream;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.api.properties.nodes.LongNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.k1coloring.ImmutableK1ColoringStreamConfig;
import org.neo4j.gds.beta.k1coloring.K1Coloring;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.beta.k1coloring.K1ColoringStreamConfig;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.partition.PartitionUtils;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.modularityoptimization.ModularityColorArray;
import org.neo4j.gds.modularityoptimization.ModularityManager;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationTask;
import org.neo4j.gds.utils.StringFormatting;

public final class ModularityOptimization
extends Algorithm<ModularityOptimization> {
    public static final int K1COLORING_MAX_ITERATIONS = 5;
    private final int concurrency;
    private final int maxIterations;
    private final long nodeCount;
    private final long minBatchSize;
    private final double tolerance;
    private final Graph graph;
    private final NodePropertyValues seedProperty;
    private final ExecutorService executor;
    private final ModularityManager modularityManager;
    private int iterationCounter;
    private boolean didConverge = false;
    private double totalNodeWeight = 0.0;
    private double modularity = -1.0;
    private HugeLongArray currentCommunities;
    private HugeLongArray nextCommunities;
    private HugeLongArray reverseSeedCommunityMapping;
    private HugeDoubleArray cumulativeNodeWeights;
    private HugeAtomicDoubleArray communityWeightUpdates;
    private ModularityColorArray modularityColorArray;

    public ModularityOptimization(Graph graph, int maxIterations, double tolerance, @Nullable NodePropertyValues seedProperty, int concurrency, int minBatchSize, ExecutorService executor, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.nodeCount = graph.nodeCount();
        this.maxIterations = maxIterations;
        this.tolerance = tolerance;
        this.seedProperty = seedProperty;
        this.executor = executor;
        this.concurrency = concurrency;
        this.minBatchSize = minBatchSize;
        if (maxIterations < 1) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Need to run at least one iteration, but got %d", (Object[])new Object[]{maxIterations}));
        }
        this.modularityManager = ModularityManager.create(graph, concurrency);
    }

    public ModularityOptimization compute() {
        this.progressTracker.beginSubTask("ModularityOptimization");
        this.progressTracker.beginSubTask("initialization");
        this.computeColoring();
        this.initSeeding();
        this.init();
        this.progressTracker.endSubTask();
        this.progressTracker.beginSubTask("compute modularity");
        long numberOfColors = this.modularityColorArray.numberOfColors();
        this.iterationCounter = 0;
        while (this.iterationCounter < this.maxIterations) {
            this.progressTracker.beginSubTask("optimizeForColor");
            long currentStartingPosition = 0L;
            for (long colorId = 0L; colorId < numberOfColors; ++colorId) {
                this.terminationFlag.assertRunning();
                currentStartingPosition = this.optimizeColor(currentStartingPosition);
            }
            boolean hasConverged = !this.updateModularity();
            this.progressTracker.endSubTask();
            if (hasConverged) {
                this.didConverge = true;
                ++this.iterationCounter;
                break;
            }
            ++this.iterationCounter;
        }
        this.progressTracker.endSubTask();
        this.progressTracker.endSubTask();
        return this;
    }

    private void computeColoring() {
        K1ColoringStreamConfig k1Config = ImmutableK1ColoringStreamConfig.builder().concurrency(this.concurrency).maxIterations(5).batchSize((int)this.minBatchSize).build();
        K1Coloring coloring = new K1ColoringFactory<K1ColoringStreamConfig>().build(this.graph, k1Config, this.progressTracker);
        coloring.setTerminationFlag(this.terminationFlag);
        this.modularityColorArray = ModularityColorArray.create(coloring.compute(), coloring.usedColors());
    }

    private void initSeeding() {
        this.currentCommunities = HugeLongArray.newArray((long)this.nodeCount);
        if (this.seedProperty == null) {
            return;
        }
        long maxSeedCommunity = this.seedProperty.getMaxLongPropertyValue().orElse(0L);
        HugeLongLongMap communityMapping = new HugeLongLongMap(this.nodeCount);
        long nextAvailableInternalCommunityId = -1L;
        for (long nodeId = 0L; nodeId < this.nodeCount; ++nodeId) {
            boolean seededValueIsMissing;
            long seedCommunity = this.seedProperty.longValue(nodeId);
            boolean bl = seededValueIsMissing = seedCommunity == Long.MIN_VALUE;
            if (seedCommunity < 0L && !seededValueIsMissing) {
                throw new IllegalArgumentException("Seeded values should be non-negative");
            }
            if (seededValueIsMissing) {
                seedCommunity = -1L;
            }
            long l = seedCommunity = seedCommunity >= 0L ? seedCommunity : this.graph.toOriginalNodeId(nodeId) + maxSeedCommunity;
            if (communityMapping.getOrDefault(seedCommunity, -1L) < 0L) {
                communityMapping.addTo(seedCommunity, ++nextAvailableInternalCommunityId);
            }
            this.currentCommunities.set(nodeId, communityMapping.getOrDefault(seedCommunity, -1L));
        }
        this.reverseSeedCommunityMapping = HugeLongArray.newArray((long)communityMapping.size());
        for (LongLongCursor entry : communityMapping) {
            this.reverseSeedCommunityMapping.set(entry.value, entry.key);
        }
    }

    private void init() {
        this.nextCommunities = HugeLongArray.newArray((long)this.nodeCount);
        this.cumulativeNodeWeights = HugeDoubleArray.newArray((long)this.nodeCount);
        this.communityWeightUpdates = HugeAtomicDoubleArray.newArray((long)this.nodeCount);
        List initTasks = PartitionUtils.rangePartition((int)this.concurrency, (long)this.nodeCount, partition -> new InitTask((RelationshipIterator)this.graph.concurrentCopy(), this.currentCommunities, this.modularityManager, this.cumulativeNodeWeights, this.seedProperty != null, (Partition)partition), Optional.of((int)this.minBatchSize));
        ParallelUtil.run((Collection)initTasks, (ExecutorService)this.executor);
        this.totalNodeWeight = initTasks.stream().mapToDouble(InitTask::localSum).sum();
        this.currentCommunities.copyTo(this.nextCommunities, this.nodeCount);
        this.modularityManager.totalWeight(this.totalNodeWeight);
    }

    private long optimizeColor(long currentStandingPosition) {
        long nextStartingCoordinate = this.modularityColorArray.nextStartingCoordinate(currentStandingPosition);
        long colorCount = nextStartingCoordinate - currentStandingPosition;
        RunWithConcurrency.builder().concurrency(this.concurrency).tasks(this.createModularityOptimizationTasks(currentStandingPosition, colorCount)).executor(this.executor).run();
        ParallelUtil.parallelStreamConsume((BaseStream)LongStream.range(0L, colorCount), (int)this.concurrency, stream -> stream.forEach(indexId -> {
            long actualIndexId = currentStandingPosition + indexId;
            long nodeId = this.modularityColorArray.nodeAtPosition(actualIndexId);
            this.currentCommunities.set(nodeId, this.nextCommunities.get(nodeId));
        }));
        ParallelUtil.parallelStreamConsume((BaseStream)LongStream.range(0L, this.nodeCount), (int)this.concurrency, stream -> stream.forEach(nodeId -> {
            double update = this.communityWeightUpdates.get(nodeId);
            this.modularityManager.communityWeightUpdate(nodeId, update);
        }));
        this.communityWeightUpdates = HugeAtomicDoubleArray.newArray((long)this.nodeCount);
        return nextStartingCoordinate;
    }

    private Collection<ModularityOptimizationTask> createModularityOptimizationTasks(long currentStandingPosition, long colorCount) {
        return PartitionUtils.rangePartition((int)this.concurrency, (long)colorCount, partition -> new ModularityOptimizationTask(this.graph, (Partition)partition, currentStandingPosition, this.totalNodeWeight, this.currentCommunities, this.nextCommunities, this.cumulativeNodeWeights, this.communityWeightUpdates, this.modularityManager, this.modularityColorArray, this.progressTracker), Optional.of((int)this.minBatchSize));
    }

    private boolean updateModularity() {
        double oldModularity = this.modularity;
        this.modularity = this.calculateModularity();
        if (this.iterationCounter == 0) {
            return true;
        }
        return this.modularity > oldModularity && Math.abs(this.modularity - oldModularity) > this.tolerance;
    }

    private double calculateModularity() {
        this.modularityManager.registerCommunities(this.currentCommunities);
        return this.modularityManager.calculateModularity();
    }

    public void release() {
        this.nextCommunities.release();
        this.communityWeightUpdates.release();
        this.cumulativeNodeWeights.release();
        this.modularityColorArray.release();
    }

    public long getCommunityId(long nodeId) {
        if (this.seedProperty == null || this.reverseSeedCommunityMapping == null) {
            return this.currentCommunities.get(nodeId);
        }
        return this.reverseSeedCommunityMapping.get(this.currentCommunities.get(nodeId));
    }

    public int getIterations() {
        return this.iterationCounter;
    }

    public double getModularity() {
        return this.modularity;
    }

    public boolean didConverge() {
        return this.didConverge;
    }

    public LongNodePropertyValues asNodeProperties() {
        return new LongNodePropertyValues(){

            public long longValue(long nodeId) {
                return ModularityOptimization.this.getCommunityId(nodeId);
            }

            public long nodeCount() {
                return ModularityOptimization.this.graph.nodeCount();
            }
        };
    }

    private static final class InitTask
    implements Runnable {
        private final RelationshipIterator relationshipIterator;
        private final HugeLongArray currentCommunities;
        ModularityManager modularityManager;
        private final HugeDoubleArray cumulativeNodeWeights;
        private final boolean isSeeded;
        private final Partition partition;
        private double localSum;

        private InitTask(RelationshipIterator relationshipIterator, HugeLongArray currentCommunities, ModularityManager modularityManager, HugeDoubleArray cumulativeNodeWeights, boolean isSeeded, Partition partition) {
            this.relationshipIterator = relationshipIterator;
            this.currentCommunities = currentCommunities;
            this.modularityManager = modularityManager;
            this.cumulativeNodeWeights = cumulativeNodeWeights;
            this.isSeeded = isSeeded;
            this.partition = partition;
            this.localSum = 0.0;
        }

        @Override
        public void run() {
            MutableDouble cumulativeWeight = new MutableDouble();
            this.partition.consume(nodeId -> {
                if (!this.isSeeded) {
                    this.currentCommunities.set(nodeId, nodeId);
                }
                cumulativeWeight.setValue(0.0);
                this.relationshipIterator.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
                    cumulativeWeight.add(w);
                    return true;
                });
                this.modularityManager.communityWeightUpdate(this.currentCommunities.get(nodeId), cumulativeWeight.doubleValue());
                this.cumulativeNodeWeights.set(nodeId, cumulativeWeight.doubleValue());
                this.localSum += cumulativeWeight.doubleValue();
            });
        }

        double localSum() {
            return this.localSum;
        }
    }
}

