/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.beta.k1coloring.ImmutableK1ColoringStreamConfig;
import org.neo4j.gds.beta.k1coloring.K1ColoringConfig;
import org.neo4j.gds.beta.k1coloring.K1ColoringFactory;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.modularityoptimization.ModularityOptimization;
import org.neo4j.gds.modularityoptimization.ModularityOptimizationConfig;

public class ModularityOptimizationFactory<T extends ModularityOptimizationConfig>
extends GraphAlgorithmFactory<ModularityOptimization, T> {
    private static final String MODULARITY_OPTIMIZATION_TASK_NAME = "ModularityOptimization";
    public static final MemoryEstimation MEMORY_ESTIMATION = MemoryEstimations.builder(ModularityOptimization.class).perNode("currentCommunities", HugeLongArray::memoryEstimation).perNode("nextCommunities", HugeLongArray::memoryEstimation).perNode("cumulativeNodeWeights", HugeDoubleArray::memoryEstimation).perNode("nodeCommunityInfluences", HugeDoubleArray::memoryEstimation).perNode("communityWeights", HugeAtomicDoubleArray::memoryEstimation).perNode("colorsUsed", MemoryUsage::sizeOfBitset).perNode("colors", HugeLongArray::memoryEstimation).rangePerNode("reversedSeedCommunityMapping", nodeCount -> MemoryRange.of((long)0L, (long)HugeLongArray.memoryEstimation((long)nodeCount))).perNode("communityWeightUpdates", HugeAtomicDoubleArray::memoryEstimation).perThread("ModularityOptimizationTask", MemoryEstimations.builder().rangePerNode("communityInfluences", nodeCount -> MemoryRange.of((long)MemoryUsage.sizeOfLongDoubleHashMap((long)50L), (long)MemoryUsage.sizeOfLongDoubleHashMap((long)Math.max(50L, nodeCount)))).build()).build();

    public MemoryEstimation memoryEstimation(T configuration) {
        return MEMORY_ESTIMATION;
    }

    public String taskName() {
        return MODULARITY_OPTIMIZATION_TASK_NAME;
    }

    public ModularityOptimization build(Graph graph, T configuration, ProgressTracker progressTracker) {
        NodePropertyValues seedProperty = configuration.seedProperty() != null ? graph.nodeProperties(configuration.seedProperty()) : null;
        return this.build(graph, configuration, seedProperty, progressTracker);
    }

    public ModularityOptimization build(Graph graph, T configuration, NodePropertyValues seedProperty, ProgressTracker progressTracker) {
        return new ModularityOptimization(graph, configuration.maxIterations(), configuration.tolerance(), seedProperty, configuration.concurrency(), configuration.batchSize(), Pools.DEFAULT, progressTracker);
    }

    public Task progressTask(Graph graph, T config) {
        return ModularityOptimizationFactory.modularityOptimizationProgressTask(graph, config);
    }

    public static <T extends BaseConfig & IterationsConfig> Task modularityOptimizationProgressTask(Graph graph, T config) {
        return Tasks.task((String)MODULARITY_OPTIMIZATION_TASK_NAME, (Task)Tasks.task((String)"initialization", (Task)K1ColoringFactory.k1ColoringProgressTask(graph, ModularityOptimizationFactory.createModularityConfig()), (Task[])new Task[0]), (Task[])new Task[]{Tasks.iterativeDynamic((String)"compute modularity", () -> List.of(Tasks.leaf((String)"optimizeForColor", (long)graph.relationshipCount())), (int)((IterationsConfig)config).maxIterations())});
    }

    private static K1ColoringConfig createModularityConfig() {
        return ImmutableK1ColoringStreamConfig.builder().maxIterations(5).build();
    }
}

