/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.modularityoptimization;

import com.carrotsearch.hppc.LongDoubleHashMap;
import com.carrotsearch.hppc.LongDoubleMap;
import com.carrotsearch.hppc.cursors.LongDoubleCursor;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableLong;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.paged.HugeAtomicDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.core.utils.partition.Partition;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.modularityoptimization.ModularityColorArray;
import org.neo4j.gds.modularityoptimization.ModularityManager;

final class ModularityOptimizationTask
implements Runnable {
    private final Graph localGraph;
    private final Partition partition;
    private final long currentStartingPosition;
    private final double totalNodeWeight;
    private final ProgressTracker progressTracker;
    private final HugeLongArray currentCommunities;
    private final HugeLongArray nextCommunities;
    private final HugeDoubleArray cumulativeNodeWeights;
    private final ModularityManager modularityManager;
    private final HugeAtomicDoubleArray communityWeightUpdates;
    private final ModularityColorArray modularityColorArray;

    ModularityOptimizationTask(Graph graph, Partition partition, long currentStartingPosition, double totalNodeWeight, HugeLongArray currentCommunities, HugeLongArray nextCommunities, HugeDoubleArray cumulativeNodeWeights, HugeAtomicDoubleArray communityWeightUpdates, ModularityManager modularityManager, ModularityColorArray modularityColorArray, ProgressTracker progressTracker) {
        this.modularityColorArray = modularityColorArray;
        this.partition = partition;
        this.currentStartingPosition = currentStartingPosition;
        this.localGraph = graph.concurrentCopy();
        this.currentCommunities = currentCommunities;
        this.nextCommunities = nextCommunities;
        this.modularityManager = modularityManager;
        this.communityWeightUpdates = communityWeightUpdates;
        this.totalNodeWeight = totalNodeWeight;
        this.cumulativeNodeWeights = cumulativeNodeWeights;
        this.progressTracker = progressTracker;
    }

    @Override
    public void run() {
        LongDoubleHashMap reuseCommunityInfluences = new LongDoubleHashMap(50);
        MutableLong relationshipsProcessed = new MutableLong();
        this.partition.consume(arg_0 -> this.lambda$run$3((LongDoubleMap)reuseCommunityInfluences, relationshipsProcessed, arg_0));
        this.progressTracker.logProgress(relationshipsProcessed.longValue());
    }

    private /* synthetic */ void lambda$run$3(LongDoubleMap reuseCommunityInfluences, MutableLong relationshipsProcessed, long indexId) {
        LongDoubleMap communityInfluences;
        long actualIndexId = this.currentStartingPosition + indexId;
        long nodeId = this.modularityColorArray.nodeAtPosition(actualIndexId);
        long currentCommunity = this.currentCommunities.get(nodeId);
        int degree = this.localGraph.degree(nodeId);
        if (degree < 50) {
            reuseCommunityInfluences.clear();
            communityInfluences = reuseCommunityInfluences;
        } else {
            communityInfluences = new LongDoubleHashMap(degree);
        }
        MutableDouble selfWeight = new MutableDouble(0.0);
        this.localGraph.forEachRelationship(nodeId, 1.0, (s, t, w) -> {
            if (s == t) {
                selfWeight.add(w);
            }
            long targetCommunity = this.currentCommunities.get(t);
            communityInfluences.addTo(targetCommunity, w);
            return true;
        });
        long nextCommunity = currentCommunity;
        double maxGain = 0.0;
        double eix = communityInfluences.get(currentCommunity) - selfWeight.doubleValue();
        double cumulativeNodeWeight = this.cumulativeNodeWeights.get(nodeId);
        double ax = this.modularityManager.getCommunityWeight(currentCommunity) - cumulativeNodeWeight;
        for (LongDoubleCursor cursor : communityInfluences) {
            double ay;
            double eiy;
            double currentGain;
            long communityCandidate = cursor.key;
            if (currentCommunity == communityCandidate || !((currentGain = ((eiy = cursor.value) - eix) / (this.totalNodeWeight / 2.0) + (2.0 * cumulativeNodeWeight * ax - 2.0 * cumulativeNodeWeight * (ay = this.modularityManager.getCommunityWeight(communityCandidate))) / Math.pow(this.totalNodeWeight, 2.0)) > maxGain) && (currentGain != maxGain || currentGain == 0.0 || nextCommunity <= communityCandidate)) continue;
            maxGain = currentGain;
            nextCommunity = communityCandidate;
        }
        this.nextCommunities.set(nodeId, nextCommunity);
        this.communityWeightUpdates.update(currentCommunity, agg -> agg - cumulativeNodeWeight);
        this.communityWeightUpdates.update(nextCommunity, agg -> agg + cumulativeNodeWeight);
        relationshipsProcessed.add((long)degree);
    }
}

