/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.BfsConsumer;
import org.neo4j.gds.msbfs.ExecutionStrategy;
import org.neo4j.gds.msbfs.SourceNodes;

public class ANPStrategy
implements ExecutionStrategy {
    final BfsConsumer perNodeAction;

    public ANPStrategy(BfsConsumer perNodeAction) {
        this.perNodeAction = perNodeAction;
    }

    @Override
    public void run(RelationshipIterator relationships, long totalNodeCount, SourceNodes sourceNodes, HugeLongArray visitSet, HugeLongArray visitNextSet, HugeLongArray seenSet, @Nullable HugeLongArray seenNextSet) {
        HugeCursor visitCursor = visitSet.newCursor();
        HugeCursor nextCursor = visitNextSet.newCursor();
        int depth = 0;
        while (true) {
            visitSet.initCursor(visitCursor);
            while (visitCursor.next()) {
                long[] array = (long[])visitCursor.array;
                int offset = visitCursor.offset;
                int limit = visitCursor.limit;
                long base = visitCursor.base;
                for (int i = offset; i < limit; ++i) {
                    if (array[i] == 0L) continue;
                    this.prepareNextVisit(relationships, array[i], base + (long)i, visitNextSet, depth);
                }
            }
            ++depth;
            boolean hasNext = false;
            visitNextSet.initCursor(nextCursor);
            while (nextCursor.next()) {
                long[] array = (long[])nextCursor.array;
                int offset = nextCursor.offset;
                int limit = nextCursor.limit;
                long base = nextCursor.base;
                for (int i = offset; i < limit; ++i) {
                    long next;
                    if (array[i] == 0L || (next = this.visitNext(base + (long)i, seenSet, visitNextSet)) == 0L) continue;
                    sourceNodes.reset(next);
                    this.perNodeAction.accept(base + (long)i, depth, sourceNodes);
                    hasNext = true;
                }
            }
            if (this.stopTraversal(hasNext, depth)) {
                return;
            }
            visitNextSet.copyTo(visitSet, totalNodeCount);
            visitNextSet.fill(0L);
        }
    }

    protected boolean stopTraversal(boolean hasNext, int depth) {
        return !hasNext;
    }

    protected void prepareNextVisit(RelationshipIterator relationships, long nodeVisit, long nodeId, HugeLongArray nextSet, int depth) {
        relationships.forEachRelationship(nodeId, (src, tgt) -> {
            nextSet.or(tgt, nodeVisit);
            return true;
        });
    }

    private long visitNext(long nodeId, HugeLongArray seenSet, HugeLongArray nextSet) {
        long seen = seenSet.get(nodeId);
        long next = nextSet.and(nodeId, seen ^ 0xFFFFFFFFFFFFFFFFL);
        seenSet.or(nodeId, next);
        return next;
    }
}

