/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.RunWithConcurrency;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.ANPStrategy;
import org.neo4j.gds.msbfs.BfsConsumer;
import org.neo4j.gds.msbfs.BfsWithPredecessorConsumer;
import org.neo4j.gds.msbfs.ExecutionStrategy;
import org.neo4j.gds.msbfs.LocalHugeLongArray;
import org.neo4j.gds.msbfs.MultiSourceBFSRunnable;
import org.neo4j.gds.msbfs.ParallelMultiSources;
import org.neo4j.gds.msbfs.PredecessorStrategy;
import org.neo4j.gds.utils.CloseableThreadLocal;

public final class MultiSourceBFSAccessMethods {
    private final CloseableThreadLocal<HugeLongArray> visits;
    private final CloseableThreadLocal<HugeLongArray> visitsNext;
    private final CloseableThreadLocal<HugeLongArray> seens;
    @Nullable
    private final CloseableThreadLocal<HugeLongArray> seensNext;
    private final long nodeCount;
    private final RelationshipIterator relationships;
    private final ExecutionStrategy strategy;
    private final boolean allowStartNodeTraversal;
    private final long @Nullable [] sourceNodes;
    private final int sourceNodeCount;
    private final long nodeOffset;

    public static MultiSourceBFSAccessMethods aggregatedNeighborProcessingWithoutSourceNodes(long nodeCount, RelationshipIterator relationships, BfsConsumer perNodeAction) {
        return MultiSourceBFSAccessMethods.createWithoutSeensNextOrSourceNodesOrStartNodeTraversal(nodeCount, relationships, new ANPStrategy(perNodeAction));
    }

    public static MultiSourceBFSAccessMethods aggregatedNeighborProcessing(long nodeCount, RelationshipIterator relationships, BfsConsumer perNodeAction, long[] sourceNodes) {
        return MultiSourceBFSAccessMethods.createWithoutSeensNextOrStartNodeTraversal(nodeCount, relationships, new ANPStrategy(perNodeAction), sourceNodes);
    }

    public static MultiSourceBFSAccessMethods predecessorProcessingWithoutSourceNodes(Graph graph, BfsConsumer perNodeAction, BfsWithPredecessorConsumer perNeighborAction) {
        return MultiSourceBFSAccessMethods.createWithoutSourceNodesOrStartNodeTraversal(graph.nodeCount(), (RelationshipIterator)graph, new PredecessorStrategy(perNodeAction, perNeighborAction));
    }

    public static MultiSourceBFSAccessMethods predecessorProcessing(Graph graph, BfsConsumer perNodeAction, BfsWithPredecessorConsumer perNeighborAction, long[] sourceNodes) {
        return MultiSourceBFSAccessMethods.createWithoutStartNodeTraversal(graph.nodeCount(), (RelationshipIterator)graph, new PredecessorStrategy(perNodeAction, perNeighborAction), sourceNodes);
    }

    private static MultiSourceBFSAccessMethods createWithoutSeensNextOrSourceNodesOrStartNodeTraversal(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy) {
        LocalHugeLongArray visits = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray visitsNext = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seens = new LocalHugeLongArray(nodeCount);
        return new MultiSourceBFSAccessMethods(visits, visitsNext, seens, null, nodeCount, relationships, strategy, false, null, 0, 0L);
    }

    private static MultiSourceBFSAccessMethods createWithoutSeensNextOrStartNodeTraversal(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, long[] sourceNodes) {
        LocalHugeLongArray visits = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray visitsNext = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seens = new LocalHugeLongArray(nodeCount);
        return new MultiSourceBFSAccessMethods(visits, visitsNext, seens, null, nodeCount, relationships, strategy, false, sourceNodes, 0, 0L);
    }

    private static MultiSourceBFSAccessMethods createWithoutSourceNodesOrStartNodeTraversal(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy) {
        LocalHugeLongArray visits = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray visitsNext = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seens = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seensNext = new LocalHugeLongArray(nodeCount);
        return new MultiSourceBFSAccessMethods(visits, visitsNext, seens, seensNext, nodeCount, relationships, strategy, false, null, 0, 0L);
    }

    private static MultiSourceBFSAccessMethods createWithoutStartNodeTraversal(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, long[] sourceNodes) {
        if (sourceNodes.length == 0) {
            throw new IllegalArgumentException("You must provide source nodes");
        }
        Arrays.sort(sourceNodes);
        LocalHugeLongArray visits = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray visitsNext = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seens = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seensNext = new LocalHugeLongArray(nodeCount);
        return new MultiSourceBFSAccessMethods(visits, visitsNext, seens, seensNext, nodeCount, relationships, strategy, false, sourceNodes, 0, 0L);
    }

    private MultiSourceBFSAccessMethods(CloseableThreadLocal<HugeLongArray> visits, CloseableThreadLocal<HugeLongArray> visitsNext, CloseableThreadLocal<HugeLongArray> seens, @Nullable CloseableThreadLocal<HugeLongArray> seensNext, long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, boolean allowStartNodeTraversal, long @Nullable [] sourceNodes, int sourceNodeCount, long nodeOffset) {
        this.visits = visits;
        this.visitsNext = visitsNext;
        this.seens = seens;
        this.seensNext = seensNext;
        this.nodeCount = nodeCount;
        this.relationships = relationships;
        this.strategy = strategy;
        this.allowStartNodeTraversal = allowStartNodeTraversal;
        this.sourceNodes = sourceNodes;
        this.sourceNodeCount = sourceNodeCount;
        this.nodeOffset = nodeOffset;
    }

    public void run(int concurrency, ExecutorService executor) {
        int threads = this.numberOfThreads();
        Collection<MultiSourceBFSRunnable> bfss = this.allSourceBfss(threads);
        RunWithConcurrency.builder().concurrency(concurrency).tasks(bfss).maxWaitRetries((long)threads << 2).waitTime(100L, TimeUnit.MICROSECONDS).executor(executor).run();
    }

    private long sourceLength() {
        if (this.sourceNodes != null) {
            return this.sourceNodes.length;
        }
        if (this.sourceNodeCount == 0) {
            return this.nodeCount;
        }
        return this.sourceNodeCount;
    }

    private int numberOfThreads() {
        long sourceLength = this.sourceLength();
        long threads = ParallelUtil.threadCount((long)64L, (long)sourceLength);
        if ((long)((int)threads) != threads) {
            throw new IllegalArgumentException("Unable run MS-BFS on " + sourceLength + " sources.");
        }
        return (int)threads;
    }

    private Collection<MultiSourceBFSRunnable> allSourceBfss(int threads) {
        if (this.sourceNodes == null) {
            final long sourceLength = this.nodeCount;
            return new ParallelMultiSources(threads, sourceLength){

                @Override
                MultiSourceBFSRunnable next(long from, int length) {
                    return new MultiSourceBFSRunnable(MultiSourceBFSAccessMethods.this.visits, MultiSourceBFSAccessMethods.this.visitsNext, MultiSourceBFSAccessMethods.this.seens, MultiSourceBFSAccessMethods.this.seensNext, sourceLength, MultiSourceBFSAccessMethods.this.relationships.concurrentCopy(), MultiSourceBFSAccessMethods.this.strategy, MultiSourceBFSAccessMethods.this.allowStartNodeTraversal, null, length, from);
                }
            };
        }
        final long[] sourceNodes = this.sourceNodes;
        int sourceLength = sourceNodes.length;
        return new ParallelMultiSources(threads, sourceLength){

            @Override
            MultiSourceBFSRunnable next(long from, int length) {
                return new MultiSourceBFSRunnable(MultiSourceBFSAccessMethods.this.visits, MultiSourceBFSAccessMethods.this.visitsNext, MultiSourceBFSAccessMethods.this.seens, MultiSourceBFSAccessMethods.this.seensNext, MultiSourceBFSAccessMethods.this.nodeCount, MultiSourceBFSAccessMethods.this.relationships.concurrentCopy(), MultiSourceBFSAccessMethods.this.strategy, MultiSourceBFSAccessMethods.this.allowStartNodeTraversal, Arrays.copyOfRange(sourceNodes, (int)from, (int)(from + (long)length)), 0, 0L);
            }
        };
    }

    public String toString() {
        if (this.sourceNodes != null && this.sourceNodes.length > 0) {
            return "MSBFS{" + this.sourceNodes[0] + " .. " + (this.sourceNodes[this.sourceNodes.length - 1] + 1L) + " (" + this.sourceNodes.length + ")}";
        }
        return "MSBFS{" + this.nodeOffset + " .. " + (this.nodeOffset + (long)this.sourceNodeCount) + " (" + this.sourceNodeCount + ")}";
    }
}

