/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.ExecutionStrategy;
import org.neo4j.gds.msbfs.LocalHugeLongArray;
import org.neo4j.gds.msbfs.SourceNodes;
import org.neo4j.gds.utils.CloseableThreadLocal;

public final class MultiSourceBFSRunnable
implements Runnable {
    private final CloseableThreadLocal<HugeLongArray> visits;
    private final CloseableThreadLocal<HugeLongArray> visitsNext;
    private final CloseableThreadLocal<HugeLongArray> seens;
    @Nullable
    private final CloseableThreadLocal<HugeLongArray> seensNext;
    private final long nodeCount;
    private final RelationshipIterator relationships;
    private final ExecutionStrategy strategy;
    private final boolean allowStartNodeTraversal;
    private final long @Nullable [] sourceNodes;
    private final int sourceNodeCount;
    private final long nodeOffset;

    public static MultiSourceBFSRunnable createWithoutSeensNext(long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, boolean allowStartNodeTraversal, long[] sourceNodes) {
        LocalHugeLongArray visits = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray visitsNext = new LocalHugeLongArray(nodeCount);
        LocalHugeLongArray seens = new LocalHugeLongArray(nodeCount);
        return new MultiSourceBFSRunnable(visits, visitsNext, seens, null, nodeCount, relationships, strategy, allowStartNodeTraversal, sourceNodes, 0, 0L);
    }

    MultiSourceBFSRunnable(CloseableThreadLocal<HugeLongArray> visits, CloseableThreadLocal<HugeLongArray> visitsNext, CloseableThreadLocal<HugeLongArray> seens, @Nullable CloseableThreadLocal<HugeLongArray> seensNext, long nodeCount, RelationshipIterator relationships, ExecutionStrategy strategy, boolean allowStartNodeTraversal, long @Nullable [] sourceNodes, int sourceNodeCount, long nodeOffset) {
        this.visits = visits;
        this.visitsNext = visitsNext;
        this.seens = seens;
        this.seensNext = seensNext;
        this.nodeCount = nodeCount;
        this.relationships = relationships;
        this.strategy = strategy;
        this.allowStartNodeTraversal = allowStartNodeTraversal;
        this.sourceNodes = sourceNodes;
        this.sourceNodeCount = sourceNodeCount;
        this.nodeOffset = nodeOffset;
    }

    @Override
    public void run() {
        HugeLongArray visitSet = (HugeLongArray)this.visits.get();
        HugeLongArray visitNextSet = (HugeLongArray)this.visitsNext.get();
        HugeLongArray seenSet = (HugeLongArray)this.seens.get();
        HugeLongArray seenNextSet = this.seensNext != null ? (HugeLongArray)this.seensNext.get() : null;
        SourceNodes sourceNodes = this.sourceNodes == null ? this.prepareOffsetSources(visitSet, seenSet) : MultiSourceBFSRunnable.prepareSpecifiedSources(visitSet, seenSet, this.sourceNodes, this.allowStartNodeTraversal);
        this.strategy.run(this.relationships, this.nodeCount, sourceNodes, visitSet, visitNextSet, seenSet, seenNextSet);
    }

    private SourceNodes prepareOffsetSources(HugeLongArray visitSet, HugeLongArray seenSet) {
        int localNodeCount = this.sourceNodeCount;
        long nodeOffset = this.nodeOffset;
        for (int i = 0; i < localNodeCount; ++i) {
            seenSet.set(nodeOffset + (long)i, 1L << i);
            visitSet.or(nodeOffset + (long)i, 1L << i);
        }
        return new SourceNodes(nodeOffset, localNodeCount);
    }

    private static SourceNodes prepareSpecifiedSources(HugeLongArray visitSet, HugeLongArray seenSet, long[] sourceNodes, boolean allowStartNodeTraversal) {
        for (int i = 0; i < sourceNodes.length; ++i) {
            long nodeId = sourceNodes[i];
            if (!allowStartNodeTraversal) {
                seenSet.set(nodeId, 1L << i);
            }
            visitSet.or(nodeId, 1L << i);
        }
        return new SourceNodes(sourceNodes);
    }

    public String toString() {
        if (this.sourceNodes != null && this.sourceNodes.length > 0) {
            return "MSBFS{" + this.sourceNodes[0] + " .. " + (this.sourceNodes[this.sourceNodes.length - 1] + 1L) + " (" + this.sourceNodes.length + ")}";
        }
        return "MSBFS{" + this.nodeOffset + " .. " + (this.nodeOffset + (long)this.sourceNodeCount) + " (" + this.sourceNodeCount + ")}";
    }
}

