/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import java.util.AbstractCollection;
import java.util.Iterator;
import org.neo4j.gds.msbfs.MultiSourceBFSRunnable;

abstract class ParallelMultiSources
extends AbstractCollection<MultiSourceBFSRunnable>
implements Iterator<MultiSourceBFSRunnable> {
    private final int threads;
    private final long sourceLength;
    private long start = 0L;
    private int i = 0;

    ParallelMultiSources(int threads, long sourceLength) {
        this.threads = threads;
        this.sourceLength = sourceLength;
    }

    @Override
    public boolean hasNext() {
        return this.i < this.threads;
    }

    @Override
    public int size() {
        return this.threads;
    }

    @Override
    public Iterator<MultiSourceBFSRunnable> iterator() {
        this.start = 0L;
        this.i = 0;
        return this;
    }

    @Override
    public MultiSourceBFSRunnable next() {
        int len = (int)Math.min(64L, this.sourceLength - this.start);
        MultiSourceBFSRunnable bfs = this.next(this.start, len);
        this.start += (long)len;
        ++this.i;
        return bfs;
    }

    abstract MultiSourceBFSRunnable next(long var1, int var3);
}

