/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.RelationshipIterator;
import org.neo4j.gds.core.utils.paged.HugeCursor;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.msbfs.BfsConsumer;
import org.neo4j.gds.msbfs.BfsWithPredecessorConsumer;
import org.neo4j.gds.msbfs.ExecutionStrategy;
import org.neo4j.gds.msbfs.SourceNodes;

public class PredecessorStrategy
implements ExecutionStrategy {
    private final BfsConsumer perNodeAction;
    private final BfsWithPredecessorConsumer perNeighborAction;

    PredecessorStrategy(BfsConsumer perNodeAction, BfsWithPredecessorConsumer perNeighborAction) {
        this.perNodeAction = perNodeAction;
        this.perNeighborAction = perNeighborAction;
    }

    @Override
    public void run(RelationshipIterator relationships, long totalNodeCount, SourceNodes sourceNodes, HugeLongArray visitSet, HugeLongArray visitNextSet, HugeLongArray seenSet, @Nullable HugeLongArray seenNextSet) {
        Objects.requireNonNull(seenNextSet, "seenNextSet must always be initialized with the PredecessorStrategy");
        try (HugeCursor visitCursor = visitSet.newCursor();
             HugeCursor seenCursor = seenSet.newCursor();
             HugeCursor seenNextCursor = seenNextSet.newCursor();){
            AtomicInteger depth = new AtomicInteger(0);
            AtomicBoolean hasNext = new AtomicBoolean(false);
            block18: while (true) {
                hasNext.set(false);
                depth.incrementAndGet();
                visitSet.initCursor(visitCursor);
                while (true) {
                    if (!visitCursor.next()) continue block18;
                    long[] array = (long[])visitCursor.array;
                    int offset = visitCursor.offset;
                    int limit = visitCursor.limit;
                    long base = visitCursor.base;
                    for (int i = offset; i < limit; ++i) {
                        long nodeId = base + (long)i;
                        long visit = array[i];
                        if (visit == 0L) continue;
                        sourceNodes.reset(visit);
                        this.perNodeAction.accept(nodeId, depth.get() - 1, sourceNodes);
                        relationships.forEachRelationship(nodeId, (source, target) -> {
                            long next = visitSet.get(nodeId) & (seenSet.get(target) ^ 0xFFFFFFFFFFFFFFFFL);
                            if (next != 0L) {
                                visitNextSet.or(target, next);
                                seenNextSet.or(target, next);
                                sourceNodes.reset(next);
                                this.perNeighborAction.accept(target, nodeId, depth.get(), sourceNodes);
                                hasNext.set(true);
                            }
                            return true;
                        });
                    }
                    if (!hasNext.get()) {
                        return;
                    }
                    HugeCursor seen = seenSet.initCursor(seenCursor);
                    HugeCursor seenNext = seenNextSet.initCursor(seenNextCursor);
                    this.updateSeenSet((HugeCursor<long[]>)seen, (HugeCursor<long[]>)seenNext);
                    visitNextSet.copyTo(visitSet, totalNodeCount);
                    visitNextSet.fill(0L);
                }
                break;
            }
        }
    }

    private void updateSeenSet(HugeCursor<long[]> seen, HugeCursor<long[]> seenNext) {
        while (seen.next()) {
            int pos;
            seenNext.next();
            long[] seenArray = (long[])seen.array;
            long[] seenNextArray = (long[])seenNext.array;
            int end = seen.limit;
            for (pos = seen.offset; pos < end - 4; pos += 4) {
                int n = pos;
                seenArray[n] = seenArray[n] | seenNextArray[pos];
                int n2 = pos + 1;
                seenArray[n2] = seenArray[n2] | seenNextArray[pos + 1];
                int n3 = pos + 2;
                seenArray[n3] = seenArray[n3] | seenNextArray[pos + 2];
                int n4 = pos + 3;
                seenArray[n4] = seenArray[n4] | seenNextArray[pos + 3];
            }
            while (pos < end) {
                int n = pos;
                seenArray[n] = seenArray[n] | seenNextArray[pos];
                ++pos;
            }
        }
    }
}

