/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.msbfs;

import org.neo4j.gds.msbfs.BfsSources;

final class SourceNodes
implements BfsSources {
    private final long[] sourceNodes;
    private final int maxPos;
    private final int startPos;
    private final long offset;
    private long sourceMask;
    private int pos;

    SourceNodes(long[] sourceNodes) {
        this.sourceNodes = sourceNodes;
        this.maxPos = sourceNodes.length;
        this.offset = 0L;
        this.startPos = -1;
    }

    SourceNodes(long offset, int length) {
        this.sourceNodes = null;
        this.maxPos = length;
        this.offset = offset;
        this.startPos = -1;
    }

    void reset() {
        this.pos = this.startPos;
        this.fetchNext();
    }

    void reset(long sourceMask) {
        assert (sourceMask != 0L);
        this.sourceMask = sourceMask;
        this.reset();
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.maxPos;
    }

    @Override
    public long nextLong() {
        int current = this.pos;
        this.fetchNext();
        return this.sourceNodes != null ? this.sourceNodes[current] : (long)current + this.offset;
    }

    @Override
    public int size() {
        return Long.bitCount(this.sourceMask) + 1;
    }

    private void fetchNext() {
        this.pos = Long.numberOfTrailingZeros(this.sourceMask);
        this.sourceMask ^= Long.lowestOneBit(this.sourceMask);
    }
}

