/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.beta.pregel.Partitioning;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.IterationsConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.MutatePropertyConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.config.ToleranceConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.pagerank.PageRankConfig;
import org.neo4j.gds.pagerank.PageRankMutateConfig;
import org.neo4j.gds.scaling.ScalarScaler;

@Generated(from="PageRankMutateConfig", generator="Immutables")
public final class ImmutablePageRankMutateConfig
implements PageRankMutateConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final transient boolean useForkJoin;
    private final List<Long> sourceNodes;
    private final double tolerance;
    private final int maxIterations;
    private final double dampingFactor;
    private final ScalarScaler.Variant scaler;
    private final boolean isAsynchronous;
    private final Partitioning partitioning;
    private final String mutateProperty;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePageRankMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.initShim.sourceNodes(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(Objects.requireNonNull(scaler, "scaler"));
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private ImmutablePageRankMutateConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.sourceNodes(ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(Objects.requireNonNull(scaler, "scaler"));
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(Objects.requireNonNull(partitioning, "partitioning"));
        this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private ImmutablePageRankMutateConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.mutateProperty = builder.mutateProperty;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutablePageRankMutateConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutablePageRankMutateConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutablePageRankMutateConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.toleranceIsSet()) {
            this.initShim.tolerance(builder.tolerance);
        }
        if (builder.maxIterationsIsSet()) {
            this.initShim.maxIterations(builder.maxIterations);
        }
        if (builder.dampingFactorIsSet()) {
            this.initShim.dampingFactor(builder.dampingFactor);
        }
        if (builder.scaler != null) {
            this.initShim.scaler(builder.scaler);
        }
        if (builder.isAsynchronousIsSet()) {
            this.initShim.isAsynchronous(builder.isAsynchronous);
        }
        if (builder.partitioning != null) {
            this.initShim.partitioning(builder.partitioning);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private ImmutablePageRankMutateConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.tolerance(tolerance);
        this.initShim.maxIterations(maxIterations);
        this.initShim.dampingFactor(dampingFactor);
        this.initShim.scaler(scaler);
        this.initShim.isAsynchronous(isAsynchronous);
        this.initShim.partitioning(partitioning);
        this.mutateProperty = mutateProperty;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.useForkJoin = this.initShim.useForkJoin();
        this.sourceNodes = this.initShim.sourceNodes();
        this.tolerance = this.initShim.tolerance();
        this.maxIterations = this.initShim.maxIterations();
        this.dampingFactor = this.initShim.dampingFactor();
        this.scaler = this.initShim.scaler();
        this.isAsynchronous = this.initShim.isAsynchronous();
        this.partitioning = this.initShim.partitioning();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return PageRankMutateConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return PageRankMutateConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return PageRankMutateConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return PageRankMutateConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return PageRankMutateConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return PageRankMutateConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return PageRankMutateConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return PageRankMutateConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return PageRankMutateConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return PageRankMutateConfig.super.hasRelationshipWeightProperty();
    }

    private boolean useForkJoinInitialize() {
        return PageRankMutateConfig.super.useForkJoin();
    }

    private List<Long> sourceNodesInitialize() {
        return PageRankMutateConfig.super.sourceNodes();
    }

    private double toleranceInitialize() {
        return PageRankMutateConfig.super.tolerance();
    }

    private int maxIterationsInitialize() {
        return PageRankMutateConfig.super.maxIterations();
    }

    private double dampingFactorInitialize() {
        return PageRankMutateConfig.super.dampingFactor();
    }

    private ScalarScaler.Variant scalerInitialize() {
        return PageRankMutateConfig.super.scaler();
    }

    private boolean isAsynchronousInitialize() {
        return PageRankMutateConfig.super.isAsynchronous();
    }

    private Partitioning partitioningInitialize() {
        return PageRankMutateConfig.super.partitioning();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public boolean useForkJoin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useForkJoin() : this.useForkJoin;
    }

    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    @Override
    public double tolerance() {
        InitShim shim = this.initShim;
        return shim != null ? shim.tolerance() : this.tolerance;
    }

    @Override
    public int maxIterations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIterations() : this.maxIterations;
    }

    @Override
    public double dampingFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dampingFactor() : this.dampingFactor;
    }

    @Override
    public ScalarScaler.Variant scaler() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scaler() : this.scaler;
    }

    @Override
    public boolean isAsynchronous() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isAsynchronous() : this.isAsynchronous;
    }

    @Override
    public Partitioning partitioning() {
        InitShim shim = this.initShim;
        return shim != null ? shim.partitioning() : this.partitioning;
    }

    public String mutateProperty() {
        return this.mutateProperty;
    }

    public final ImmutablePageRankMutateConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(elements, true, false));
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(elements, true, false));
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, wrappedList);
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(elements, true, false));
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withTolerance(double value) {
        if (Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, value, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withMaxIterations(int value) {
        if (this.maxIterations == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, value, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withDampingFactor(double value) {
        if (Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, value, this.scaler, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withScaler(ScalarScaler.Variant value) {
        if (this.scaler == value) {
            return this;
        }
        ScalarScaler.Variant newValue = Objects.requireNonNull(value, "scaler");
        if (this.scaler.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, newValue, this.isAsynchronous, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withIsAsynchronous(boolean value) {
        if (this.isAsynchronous == value) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, value, this.partitioning, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withPartitioning(Partitioning value) {
        if (this.partitioning == value) {
            return this;
        }
        Partitioning newValue = Objects.requireNonNull(value, "partitioning");
        if (this.partitioning.equals((Object)newValue)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, newValue, this.mutateProperty));
    }

    public final ImmutablePageRankMutateConfig withMutateProperty(String value) {
        String newValue = Objects.requireNonNull(value, "mutateProperty");
        if (this.mutateProperty.equals(newValue)) {
            return this;
        }
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.sourceNodes, this.tolerance, this.maxIterations, this.dampingFactor, this.scaler, this.isAsynchronous, this.partitioning, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePageRankMutateConfig && this.equalTo((ImmutablePageRankMutateConfig)another);
    }

    private boolean equalTo(ImmutablePageRankMutateConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && this.useForkJoin == another.useForkJoin && this.sourceNodes.equals(another.sourceNodes) && Double.doubleToLongBits(this.tolerance) == Double.doubleToLongBits(another.tolerance) && this.maxIterations == another.maxIterations && Double.doubleToLongBits(this.dampingFactor) == Double.doubleToLongBits(another.dampingFactor) && this.scaler.equals((Object)another.scaler) && this.isAsynchronous == another.isAsynchronous && this.partitioning.equals((Object)another.partitioning) && this.mutateProperty.equals(another.mutateProperty);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.useForkJoin);
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + Double.hashCode(this.tolerance);
        h += (h << 5) + this.maxIterations;
        h += (h << 5) + Double.hashCode(this.dampingFactor);
        h += (h << 5) + this.scaler.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isAsynchronous);
        h += (h << 5) + this.partitioning.hashCode();
        h += (h << 5) + this.mutateProperty.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PageRankMutateConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 21) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        builder.append(", ");
        builder.append("useForkJoin=").append(this.useForkJoin);
        builder.append(", ");
        builder.append("sourceNodes=").append(this.sourceNodes);
        builder.append(", ");
        builder.append("tolerance=").append(this.tolerance);
        builder.append(", ");
        builder.append("maxIterations=").append(this.maxIterations);
        builder.append(", ");
        builder.append("dampingFactor=").append(this.dampingFactor);
        builder.append(", ");
        builder.append("scaler=").append(this.scaler);
        builder.append(", ");
        builder.append("isAsynchronous=").append(this.isAsynchronous);
        builder.append(", ");
        builder.append("partitioning=").append(this.partitioning);
        builder.append(", ");
        builder.append("mutateProperty=").append(this.mutateProperty);
        return builder.append("}").toString();
    }

    public static PageRankMutateConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, List<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        return ImmutablePageRankMutateConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning, mutateProperty);
    }

    public static PageRankMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning, mutateProperty));
    }

    public static PageRankMutateConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Iterable<Long> sourceNodes, double tolerance, int maxIterations, double dampingFactor, ScalarScaler.Variant scaler, boolean isAsynchronous, Partitioning partitioning, String mutateProperty) {
        return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, sourceNodes, tolerance, maxIterations, dampingFactor, scaler, isAsynchronous, partitioning, mutateProperty));
    }

    private static ImmutablePageRankMutateConfig validate(ImmutablePageRankMutateConfig instance) {
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static PageRankMutateConfig copyOf(PageRankMutateConfig instance) {
        if (instance instanceof ImmutablePageRankMutateConfig) {
            return (ImmutablePageRankMutateConfig)instance;
        }
        return ImmutablePageRankMutateConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PageRankMutateConfig", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MUTATE_PROPERTY = 1L;
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SOURCE_NODES = 64L;
        private static final long OPT_BIT_TOLERANCE = 128L;
        private static final long OPT_BIT_MAX_ITERATIONS = 256L;
        private static final long OPT_BIT_DAMPING_FACTOR = 512L;
        private static final long OPT_BIT_IS_ASYNCHRONOUS = 1024L;
        private long initBits = 1L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private List<Long> sourceNodes = null;
        private double tolerance;
        private int maxIterations;
        private double dampingFactor;
        private ScalarScaler.Variant scaler;
        private boolean isAsynchronous;
        private Partitioning partitioning;
        private String mutateProperty;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ToleranceConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MutatePropertyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PregelConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IterationsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PageRankMutateConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            Optional relationshipWeightPropertyOptional;
            long bits = 0L;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof PageRankConfig) {
                instance = (PageRankConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
                this.dampingFactor(instance.dampingFactor());
                this.scaler(instance.scaler());
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof ToleranceConfig) {
                instance = (ToleranceConfig)object;
                if ((bits & 8L) == 0L) {
                    this.tolerance(instance.tolerance());
                    bits |= 8L;
                }
            }
            if (object instanceof MutatePropertyConfig) {
                instance = (MutatePropertyConfig)object;
                this.mutateProperty(instance.mutateProperty());
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                this.addAllSourceNodes(instance.sourceNodes());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof PregelConfig) {
                instance = (PregelConfig)object;
                if ((bits & 4L) == 0L) {
                    this.partitioning(instance.partitioning());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.isAsynchronous(instance.isAsynchronous());
                    bits |= 2L;
                }
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
            if (object instanceof IterationsConfig) {
                instance = (IterationsConfig)object;
                if ((bits & 1L) == 0L) {
                    this.maxIterations(instance.maxIterations());
                    bits |= 1L;
                }
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder scaler(ScalarScaler.Variant scaler) {
            this.scaler = Objects.requireNonNull(scaler, "scaler");
            return this;
        }

        public final Builder isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder partitioning(Partitioning partitioning) {
            this.partitioning = Objects.requireNonNull(partitioning, "partitioning");
            return this;
        }

        public final Builder mutateProperty(String mutateProperty) {
            this.mutateProperty = Objects.requireNonNull(mutateProperty, "mutateProperty");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.tolerance = 0.0;
            this.maxIterations = 0;
            this.dampingFactor = 0.0;
            this.scaler = null;
            this.isAsynchronous = false;
            this.partitioning = null;
            this.mutateProperty = null;
            return this;
        }

        public PageRankMutateConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutablePageRankMutateConfig.validate(new ImmutablePageRankMutateConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean toleranceIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean maxIterationsIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean dampingFactorIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean isAsynchronousIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("mutateProperty");
            }
            return "Cannot build PageRankMutateConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PageRankMutateConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte useForkJoinBuildStage = 0;
        private boolean useForkJoin;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte toleranceBuildStage = 0;
        private double tolerance;
        private byte maxIterationsBuildStage = 0;
        private int maxIterations;
        private byte dampingFactorBuildStage = 0;
        private double dampingFactor;
        private byte scalerBuildStage = 0;
        private ScalarScaler.Variant scaler;
        private byte isAsynchronousBuildStage = 0;
        private boolean isAsynchronous;
        private byte partitioningBuildStage = 0;
        private Partitioning partitioning;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutablePageRankMutateConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutablePageRankMutateConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutablePageRankMutateConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutablePageRankMutateConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutablePageRankMutateConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutablePageRankMutateConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutablePageRankMutateConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(ImmutablePageRankMutateConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(ImmutablePageRankMutateConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutablePageRankMutateConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        boolean useForkJoin() {
            if (this.useForkJoinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useForkJoinBuildStage == 0) {
                this.useForkJoinBuildStage = (byte)-1;
                this.useForkJoin = ImmutablePageRankMutateConfig.this.useForkJoinInitialize();
                this.useForkJoinBuildStage = 1;
            }
            return this.useForkJoin;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutablePageRankMutateConfig.createUnmodifiableList(false, ImmutablePageRankMutateConfig.createSafeList(ImmutablePageRankMutateConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        double tolerance() {
            if (this.toleranceBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toleranceBuildStage == 0) {
                this.toleranceBuildStage = (byte)-1;
                this.tolerance = ImmutablePageRankMutateConfig.this.toleranceInitialize();
                this.toleranceBuildStage = 1;
            }
            return this.tolerance;
        }

        void tolerance(double tolerance) {
            this.tolerance = tolerance;
            this.toleranceBuildStage = 1;
        }

        int maxIterations() {
            if (this.maxIterationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIterationsBuildStage == 0) {
                this.maxIterationsBuildStage = (byte)-1;
                this.maxIterations = ImmutablePageRankMutateConfig.this.maxIterationsInitialize();
                this.maxIterationsBuildStage = 1;
            }
            return this.maxIterations;
        }

        void maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            this.maxIterationsBuildStage = 1;
        }

        double dampingFactor() {
            if (this.dampingFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dampingFactorBuildStage == 0) {
                this.dampingFactorBuildStage = (byte)-1;
                this.dampingFactor = ImmutablePageRankMutateConfig.this.dampingFactorInitialize();
                this.dampingFactorBuildStage = 1;
            }
            return this.dampingFactor;
        }

        void dampingFactor(double dampingFactor) {
            this.dampingFactor = dampingFactor;
            this.dampingFactorBuildStage = 1;
        }

        ScalarScaler.Variant scaler() {
            if (this.scalerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.scalerBuildStage == 0) {
                this.scalerBuildStage = (byte)-1;
                this.scaler = Objects.requireNonNull(ImmutablePageRankMutateConfig.this.scalerInitialize(), "scaler");
                this.scalerBuildStage = 1;
            }
            return this.scaler;
        }

        void scaler(ScalarScaler.Variant scaler) {
            this.scaler = scaler;
            this.scalerBuildStage = 1;
        }

        boolean isAsynchronous() {
            if (this.isAsynchronousBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isAsynchronousBuildStage == 0) {
                this.isAsynchronousBuildStage = (byte)-1;
                this.isAsynchronous = ImmutablePageRankMutateConfig.this.isAsynchronousInitialize();
                this.isAsynchronousBuildStage = 1;
            }
            return this.isAsynchronous;
        }

        void isAsynchronous(boolean isAsynchronous) {
            this.isAsynchronous = isAsynchronous;
            this.isAsynchronousBuildStage = 1;
        }

        Partitioning partitioning() {
            if (this.partitioningBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.partitioningBuildStage == 0) {
                this.partitioningBuildStage = (byte)-1;
                this.partitioning = Objects.requireNonNull(ImmutablePageRankMutateConfig.this.partitioningInitialize(), "partitioning");
                this.partitioningBuildStage = 1;
            }
            return this.partitioning;
        }

        void partitioning(Partitioning partitioning) {
            this.partitioning = partitioning;
            this.partitioningBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.useForkJoinBuildStage == -1) {
                attributes.add("useForkJoin");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.toleranceBuildStage == -1) {
                attributes.add("tolerance");
            }
            if (this.maxIterationsBuildStage == -1) {
                attributes.add("maxIterations");
            }
            if (this.dampingFactorBuildStage == -1) {
                attributes.add("dampingFactor");
            }
            if (this.scalerBuildStage == -1) {
                attributes.add("scaler");
            }
            if (this.isAsynchronousBuildStage == -1) {
                attributes.add("isAsynchronous");
            }
            if (this.partitioningBuildStage == -1) {
                attributes.add("partitioning");
            }
            return "Cannot build PageRankMutateConfig, attribute initializers form cycle " + attributes;
        }
    }
}

