/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import com.carrotsearch.hppc.LongScatterSet;
import com.carrotsearch.hppc.LongSet;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongToDoubleFunction;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Pregel;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.degree.DegreeCentrality;
import org.neo4j.gds.degree.DegreeCentralityConfig;
import org.neo4j.gds.degree.DegreeCentralityConfigImpl;
import org.neo4j.gds.pagerank.ArticleRankComputation;
import org.neo4j.gds.pagerank.EigenvectorComputation;
import org.neo4j.gds.pagerank.PageRankAlgorithm;
import org.neo4j.gds.pagerank.PageRankComputation;
import org.neo4j.gds.pagerank.PageRankConfig;

public class PageRankAlgorithmFactory<CONFIG extends PageRankConfig>
extends GraphAlgorithmFactory<PageRankAlgorithm, CONFIG> {
    private final Mode mode;

    static <CONFIG extends PageRankConfig> Task pagerankProgressTask(Graph graph, CONFIG config) {
        return Pregel.progressTask((Graph)graph, config, (String)"PageRank");
    }

    private static double averageDegree(Graph graph, int concurrency) {
        LongAdder degreeSum = new LongAdder();
        ParallelUtil.parallelForEachNode((Graph)graph, (int)concurrency, nodeId -> degreeSum.add(graph.degree(nodeId)));
        return (double)degreeSum.sum() / (double)graph.nodeCount();
    }

    public PageRankAlgorithmFactory() {
        this(Mode.PAGE_RANK);
    }

    public PageRankAlgorithmFactory(Mode mode) {
        this.mode = mode;
    }

    public String taskName() {
        return this.mode.name();
    }

    public PageRankAlgorithm build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        Object computation;
        LongToDoubleFunction degreeFunction = this.degreeFunction(graph, configuration);
        LongScatterSet mappedSourceNodes = new LongScatterSet(configuration.sourceNodes().size());
        configuration.sourceNodes().stream().mapToLong(arg_0 -> ((Graph)graph).toMappedNodeId(arg_0)).forEach(arg_0 -> ((LongScatterSet)mappedSourceNodes).add(arg_0));
        if (this.mode == Mode.ARTICLE_RANK) {
            double avgDegree = PageRankAlgorithmFactory.averageDegree(graph, configuration.concurrency());
            computation = new ArticleRankComputation((PageRankConfig)configuration, (LongSet)mappedSourceNodes, degreeFunction, avgDegree);
        } else if (this.mode == Mode.EIGENVECTOR) {
            degreeFunction = configuration.hasRelationshipWeightProperty() ? degreeFunction : nodeId -> 1.0;
            computation = new EigenvectorComputation(graph.nodeCount(), (PageRankConfig)configuration, (LongSet)mappedSourceNodes, degreeFunction);
        } else {
            computation = new PageRankComputation((PageRankConfig)configuration, (LongSet)mappedSourceNodes, degreeFunction);
        }
        return new PageRankAlgorithm(graph, (PageRankConfig)configuration, (PregelComputation<PageRankConfig>)computation, this.mode, Pools.DEFAULT, progressTracker);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return PageRankAlgorithmFactory.pagerankProgressTask(graph, config);
    }

    @NotNull
    private LongToDoubleFunction degreeFunction(Graph graph, CONFIG configuration) {
        DegreeCentralityConfig config = new DegreeCentralityConfigImpl.Builder().concurrency(configuration.concurrency()).relationshipWeightProperty(configuration.relationshipWeightProperty()).build();
        DegreeCentrality degreeCentrality = new DegreeCentrality(graph, Pools.DEFAULT, config, ProgressTracker.NULL_TRACKER);
        DegreeCentrality.DegreeFunction degrees = degreeCentrality.compute();
        return degrees::get;
    }

    public MemoryEstimation memoryEstimation(PageRankConfig configuration) {
        return Pregel.memoryEstimation((PregelSchema)new PregelSchema.Builder().add("pagerank", ValueType.DOUBLE).build(), (boolean)false, (boolean)false);
    }

    public static enum Mode {
        PAGE_RANK,
        ARTICLE_RANK,
        EIGENVECTOR;

    }
}

