/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pagerank;

import com.carrotsearch.hppc.LongSet;
import java.util.Optional;
import java.util.function.LongToDoubleFunction;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.beta.pregel.Messages;
import org.neo4j.gds.beta.pregel.PregelComputation;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.beta.pregel.Reducer;
import org.neo4j.gds.beta.pregel.context.ComputeContext;
import org.neo4j.gds.beta.pregel.context.InitContext;
import org.neo4j.gds.pagerank.PageRankConfig;

public final class PageRankComputation
implements PregelComputation<PageRankConfig> {
    static final String PAGE_RANK = "pagerank";
    private final boolean hasSourceNodes;
    private final LongSet sourceNodes;
    private final LongToDoubleFunction degreeFunction;
    private final double dampingFactor;
    private final double tolerance;
    private final double alpha;

    PageRankComputation(PageRankConfig config, LongSet sourceNodes, LongToDoubleFunction degreeFunction) {
        this.dampingFactor = config.dampingFactor();
        this.tolerance = config.tolerance();
        this.alpha = 1.0 - this.dampingFactor;
        this.sourceNodes = sourceNodes;
        this.hasSourceNodes = !sourceNodes.isEmpty();
        this.degreeFunction = degreeFunction;
    }

    public PregelSchema schema(PageRankConfig config) {
        return new PregelSchema.Builder().add(PAGE_RANK, ValueType.DOUBLE).build();
    }

    public void init(InitContext<PageRankConfig> context) {
        context.setNodeValue(PAGE_RANK, this.initialValue(context));
    }

    private double initialValue(InitContext<PageRankConfig> context) {
        if (!this.hasSourceNodes || this.sourceNodes.contains(context.nodeId())) {
            return this.alpha;
        }
        return 0.0;
    }

    public void compute(ComputeContext<PageRankConfig> context, Messages messages) {
        double rank;
        double delta = rank = context.doubleNodeValue(PAGE_RANK);
        if (!context.isInitialSuperstep()) {
            double sum = 0.0;
            for (Double message : messages) {
                sum += message.doubleValue();
            }
            delta = this.dampingFactor * sum;
            context.setNodeValue(PAGE_RANK, rank + delta);
        }
        if (delta > this.tolerance || context.isInitialSuperstep()) {
            double degree = this.degreeFunction.applyAsDouble(context.nodeId());
            if (degree > 0.0) {
                context.sendToNeighbors(delta / degree);
            }
        } else {
            context.voteToHalt();
        }
    }

    public Optional<Reducer> reducer() {
        return Optional.of(new Reducer.Sum());
    }

    public double applyRelationshipWeight(double nodeValue, double relationshipWeight) {
        return nodeValue * relationshipWeight;
    }
}

