/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.paths.PathResult;

@Generated(from="PathResult", generator="Immutables")
public final class ImmutablePathResult
implements PathResult {
    private final long index;
    private final long sourceNode;
    private final long targetNode;
    private final transient double totalCost;
    private final long[] nodeIds;
    private final long[] relationshipIds;
    private final double[] costs;

    private ImmutablePathResult(long index, long sourceNode, long targetNode, long[] nodeIds, long[] relationshipIds, double[] costs) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.nodeIds = (long[])nodeIds.clone();
        this.relationshipIds = (long[])relationshipIds.clone();
        this.costs = (double[])costs.clone();
        this.totalCost = PathResult.super.totalCost();
    }

    private ImmutablePathResult(ImmutablePathResult original, long index, long sourceNode, long targetNode, long[] nodeIds, long[] relationshipIds, double[] costs) {
        this.index = index;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.nodeIds = nodeIds;
        this.relationshipIds = relationshipIds;
        this.costs = costs;
        this.totalCost = PathResult.super.totalCost();
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public long sourceNode() {
        return this.sourceNode;
    }

    @Override
    public long targetNode() {
        return this.targetNode;
    }

    @Override
    public double totalCost() {
        return this.totalCost;
    }

    @Override
    public long[] nodeIds() {
        return (long[])this.nodeIds.clone();
    }

    @Override
    public long[] relationshipIds() {
        return (long[])this.relationshipIds.clone();
    }

    @Override
    public double[] costs() {
        return (double[])this.costs.clone();
    }

    public final ImmutablePathResult withIndex(long value) {
        if (this.index == value) {
            return this;
        }
        return new ImmutablePathResult(this, value, this.sourceNode, this.targetNode, this.nodeIds, this.relationshipIds, this.costs);
    }

    public final ImmutablePathResult withSourceNode(long value) {
        if (this.sourceNode == value) {
            return this;
        }
        return new ImmutablePathResult(this, this.index, value, this.targetNode, this.nodeIds, this.relationshipIds, this.costs);
    }

    public final ImmutablePathResult withTargetNode(long value) {
        if (this.targetNode == value) {
            return this;
        }
        return new ImmutablePathResult(this, this.index, this.sourceNode, value, this.nodeIds, this.relationshipIds, this.costs);
    }

    public final ImmutablePathResult withNodeIds(long ... elements) {
        long[] newValue = (long[])elements.clone();
        return new ImmutablePathResult(this, this.index, this.sourceNode, this.targetNode, newValue, this.relationshipIds, this.costs);
    }

    public final ImmutablePathResult withRelationshipIds(long ... elements) {
        long[] newValue = (long[])elements.clone();
        return new ImmutablePathResult(this, this.index, this.sourceNode, this.targetNode, this.nodeIds, newValue, this.costs);
    }

    public final ImmutablePathResult withCosts(double ... elements) {
        double[] newValue = (double[])elements.clone();
        return new ImmutablePathResult(this, this.index, this.sourceNode, this.targetNode, this.nodeIds, this.relationshipIds, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePathResult && this.equalTo((ImmutablePathResult)another);
    }

    private boolean equalTo(ImmutablePathResult another) {
        return this.sourceNode == another.sourceNode && this.targetNode == another.targetNode && Double.doubleToLongBits(this.totalCost) == Double.doubleToLongBits(another.totalCost) && Arrays.equals(this.nodeIds, another.nodeIds) && Arrays.equals(this.relationshipIds, another.relationshipIds) && Arrays.equals(this.costs, another.costs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.sourceNode);
        h += (h << 5) + Long.hashCode(this.targetNode);
        h += (h << 5) + Double.hashCode(this.totalCost);
        h += (h << 5) + Arrays.hashCode(this.nodeIds);
        h += (h << 5) + Arrays.hashCode(this.relationshipIds);
        h += (h << 5) + Arrays.hashCode(this.costs);
        return h;
    }

    public String toString() {
        return "PathResult{sourceNode=" + this.sourceNode + ", targetNode=" + this.targetNode + ", totalCost=" + this.totalCost + ", nodeIds=" + Arrays.toString(this.nodeIds) + ", relationshipIds=" + Arrays.toString(this.relationshipIds) + ", costs=" + Arrays.toString(this.costs) + "}";
    }

    public static PathResult of(long index, long sourceNode, long targetNode, long[] nodeIds, long[] relationshipIds, double[] costs) {
        return new ImmutablePathResult(index, sourceNode, targetNode, nodeIds, relationshipIds, costs);
    }

    public static PathResult copyOf(PathResult instance) {
        if (instance instanceof ImmutablePathResult) {
            return (ImmutablePathResult)instance;
        }
        return ImmutablePathResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PathResult", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_INDEX = 1L;
        private static final long INIT_BIT_SOURCE_NODE = 2L;
        private static final long INIT_BIT_TARGET_NODE = 4L;
        private static final long INIT_BIT_NODE_IDS = 8L;
        private static final long INIT_BIT_RELATIONSHIP_IDS = 16L;
        private static final long INIT_BIT_COSTS = 32L;
        private long initBits = 63L;
        private long index;
        private long sourceNode;
        private long targetNode;
        private long[] nodeIds;
        private long[] relationshipIds;
        private double[] costs;

        private Builder() {
        }

        public final Builder from(PathResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.index(instance.index());
            this.sourceNode(instance.sourceNode());
            this.targetNode(instance.targetNode());
            this.nodeIds(instance.nodeIds());
            this.relationshipIds(instance.relationshipIds());
            this.costs(instance.costs());
            return this;
        }

        public final Builder index(long index) {
            this.index = index;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder sourceNode(long sourceNode) {
            this.sourceNode = sourceNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder targetNode(long targetNode) {
            this.targetNode = targetNode;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder nodeIds(long ... nodeIds) {
            this.nodeIds = (long[])nodeIds.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder relationshipIds(long ... relationshipIds) {
            this.relationshipIds = (long[])relationshipIds.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder costs(double ... costs) {
            this.costs = (double[])costs.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public Builder clear() {
            this.initBits = 63L;
            this.index = 0L;
            this.sourceNode = 0L;
            this.targetNode = 0L;
            this.nodeIds = null;
            this.relationshipIds = null;
            this.costs = null;
            return this;
        }

        public PathResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePathResult(null, this.index, this.sourceNode, this.targetNode, this.nodeIds, this.relationshipIds, this.costs);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("index");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("sourceNode");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("targetNode");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("nodeIds");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("relationshipIds");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("costs");
            }
            return "Cannot build PathResult, some of required attributes are not set " + attributes;
        }
    }
}

