/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.astar;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.paths.astar.AStar;
import org.neo4j.gds.paths.astar.config.ShortestPathAStarBaseConfig;
import org.neo4j.gds.paths.dijkstra.DijkstraFactory;

public class AStarFactory<CONFIG extends ShortestPathAStarBaseConfig>
extends GraphAlgorithmFactory<AStar, CONFIG> {
    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return AStar.memoryEstimation();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return DijkstraFactory.dijkstraProgressTask(this.taskName(), graph);
    }

    public String taskName() {
        return "AStar";
    }

    public AStar build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return AStar.sourceTarget(graph, configuration, progressTracker);
    }
}

