/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.delta;

import java.util.List;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.paths.delta.DeltaStepping;
import org.neo4j.gds.paths.delta.config.AllShortestPathsDeltaBaseConfig;

public class DeltaSteppingFactory<T extends AllShortestPathsDeltaBaseConfig>
extends GraphAlgorithmFactory<DeltaStepping, T> {
    public DeltaStepping build(Graph graph, T configuration, ProgressTracker progressTracker) {
        return DeltaStepping.of(graph, configuration, Pools.DEFAULT, progressTracker);
    }

    public String taskName() {
        return "DeltaStepping";
    }

    public Task progressTask(Graph graphOrGraphStore, AllShortestPathsDeltaBaseConfig config) {
        return Tasks.iterativeOpen((String)this.taskName(), () -> List.of(Tasks.leaf((String)DeltaStepping.Phase.RELAX.name()), Tasks.leaf((String)DeltaStepping.Phase.SYNC.name())));
    }

    public MemoryEstimation memoryEstimation(T configuration) {
        return DeltaStepping.memoryEstimation(true);
    }
}

