/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.dijkstra;

import com.carrotsearch.hppc.BitSet;
import com.carrotsearch.hppc.DoubleArrayDeque;
import com.carrotsearch.hppc.LongArrayDeque;
import java.util.Optional;
import java.util.function.LongToDoubleFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeLongLongMap;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.queue.HugeLongPriorityQueue;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.paths.AllShortestPathsBaseConfig;
import org.neo4j.gds.paths.ImmutablePathResult;
import org.neo4j.gds.paths.PathResult;
import org.neo4j.gds.paths.ShortestPathBaseConfig;
import org.neo4j.gds.paths.dijkstra.DijkstraResult;

public final class Dijkstra
extends Algorithm<DijkstraResult> {
    public static final String DESCRIPTION_SOURCE_TARGET = "The Dijkstra shortest path algorithm computes the shortest (weighted) path between one node and any other node in the graph.";
    private static final long NO_RELATIONSHIP = -1L;
    private final Graph graph;
    private final TraversalPredicate traversalPredicate;
    private TraversalState traversalState;
    private long sourceNode;
    private final HugeLongPriorityQueue queue;
    private final HugeLongLongMap predecessors;
    private final boolean trackRelationships;
    private final HugeLongLongMap relationships;
    private final BitSet visited;
    private long pathIndex;
    private RelationshipFilter relationshipFilter = (sourceId, targetId, relationshipId) -> true;
    private static final long[] EMPTY_ARRAY = new long[0];

    public static Dijkstra sourceTarget(Graph graph, ShortestPathBaseConfig config, Optional<HeuristicFunction> heuristicFunction, ProgressTracker progressTracker) {
        long sourceNode = graph.toMappedNodeId(config.sourceNode());
        long targetNode = graph.toMappedNodeId(config.targetNode());
        return new Dijkstra(graph, sourceNode, node -> node == targetNode ? TraversalState.EMIT_AND_STOP : TraversalState.CONTINUE, config.trackRelationships(), heuristicFunction, progressTracker);
    }

    public static Dijkstra singleSource(Graph graph, AllShortestPathsBaseConfig config, Optional<HeuristicFunction> heuristicFunction, ProgressTracker progressTracker) {
        return new Dijkstra(graph, graph.toMappedNodeId(config.sourceNode()), node -> TraversalState.EMIT_AND_CONTINUE, config.trackRelationships(), heuristicFunction, progressTracker);
    }

    public static MemoryEstimation memoryEstimation(boolean trackRelationships) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(Dijkstra.class).add("priority queue", HugeLongPriorityQueue.memoryEstimation()).add("reverse path", HugeLongLongMap.memoryEstimation());
        if (trackRelationships) {
            builder.add("relationship ids", HugeLongLongMap.memoryEstimation());
        }
        return builder.perNode("visited set", MemoryUsage::sizeOfBitset).build();
    }

    private Dijkstra(Graph graph, long sourceNode, TraversalPredicate traversalPredicate, boolean trackRelationships, Optional<HeuristicFunction> heuristicFunction, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.sourceNode = sourceNode;
        this.traversalPredicate = traversalPredicate;
        this.traversalState = TraversalState.CONTINUE;
        this.trackRelationships = trackRelationships;
        this.queue = heuristicFunction.map(fn -> Dijkstra.minPriorityQueue(graph.nodeCount(), fn)).orElseGet(() -> HugeLongPriorityQueue.min((long)graph.nodeCount()));
        this.predecessors = new HugeLongLongMap();
        this.relationships = trackRelationships ? new HugeLongLongMap() : null;
        this.visited = new BitSet();
        this.pathIndex = 0L;
    }

    public Dijkstra withSourceNode(long sourceNode) {
        this.sourceNode = sourceNode;
        return this;
    }

    public Dijkstra withRelationshipFilter(RelationshipFilter relationshipFilter) {
        this.relationshipFilter = this.relationshipFilter.and(relationshipFilter);
        return this;
    }

    public void resetTraversalState() {
        this.traversalState = TraversalState.CONTINUE;
        this.queue.clear();
        this.visited.clear();
        if (this.trackRelationships) {
            this.relationships.clear();
        }
    }

    public DijkstraResult compute() {
        this.progressTracker.beginSubTask();
        this.queue.add(this.sourceNode, 0.0);
        ImmutablePathResult.Builder pathResultBuilder = ImmutablePathResult.builder().sourceNode(this.sourceNode);
        Stream<PathResult> paths = Stream.generate(() -> this.next(this.traversalPredicate, pathResultBuilder)).takeWhile(pathResult -> pathResult != PathResult.EMPTY);
        return new DijkstraResult(paths, () -> ((ProgressTracker)this.progressTracker).endSubTask());
    }

    private PathResult next(TraversalPredicate traversalPredicate, ImmutablePathResult.Builder pathResultBuilder) {
        MutableInt relationshipId = new MutableInt();
        while (!this.queue.isEmpty() && this.terminationFlag.running() && this.traversalState != TraversalState.EMIT_AND_STOP) {
            long node = this.queue.pop();
            double cost = this.queue.cost(node);
            this.visited.set(node);
            this.progressTracker.logProgress((long)this.graph.degree(node));
            relationshipId.setValue(0);
            this.graph.forEachRelationship(node, 1.0, (source, target, weight) -> {
                if (this.relationshipFilter.test(source, target, relationshipId.longValue())) {
                    this.updateCost(source, target, relationshipId.intValue(), weight + cost);
                }
                relationshipId.increment();
                return true;
            });
            this.traversalState = traversalPredicate.apply(node);
            if (this.traversalState != TraversalState.EMIT_AND_CONTINUE && this.traversalState != TraversalState.EMIT_AND_STOP) continue;
            return this.pathResult(node, pathResultBuilder);
        }
        return PathResult.EMPTY;
    }

    private void updateCost(long source, long target, long relationshipId, double newCost) {
        if (this.visited.get(target)) {
            return;
        }
        if (!this.queue.containsElement(target)) {
            this.queue.add(target, newCost);
            this.predecessors.put(target, source);
            if (this.trackRelationships) {
                this.relationships.put(target, relationshipId);
            }
        } else if (newCost < this.queue.cost(target)) {
            this.queue.set(target, newCost);
            this.predecessors.put(target, source);
            if (this.trackRelationships) {
                this.relationships.put(target, relationshipId);
            }
        }
    }

    private PathResult pathResult(long target, ImmutablePathResult.Builder pathResultBuilder) {
        long lastNode;
        LongArrayDeque pathNodeIds = new LongArrayDeque();
        LongArrayDeque relationshipIds = this.trackRelationships ? new LongArrayDeque() : null;
        DoubleArrayDeque costs = new DoubleArrayDeque();
        long pathStart = this.sourceNode;
        long prevNode = lastNode = target;
        while (true) {
            pathNodeIds.addFirst(lastNode);
            costs.addFirst(this.queue.cost(lastNode));
            if (lastNode == pathStart) break;
            prevNode = lastNode;
            lastNode = this.predecessors.getOrDefault(lastNode, pathStart);
            if (!this.trackRelationships) continue;
            relationshipIds.addFirst(this.relationships.getOrDefault(prevNode, -1L));
        }
        return pathResultBuilder.index(this.pathIndex++).targetNode(target).nodeIds(pathNodeIds.toArray()).relationshipIds(this.trackRelationships ? relationshipIds.toArray() : EMPTY_ARRAY).costs(costs.toArray()).build();
    }

    public void release() {
    }

    private static HugeLongPriorityQueue minPriorityQueue(long capacity, final HeuristicFunction heuristicFunction) {
        return new HugeLongPriorityQueue(capacity){

            protected boolean lessThan(long a, long b) {
                return heuristicFunction.applyAsDouble(a) + this.costValues.get(a) < heuristicFunction.applyAsDouble(b) + this.costValues.get(b);
            }
        };
    }

    @FunctionalInterface
    public static interface HeuristicFunction
    extends LongToDoubleFunction {
    }

    @FunctionalInterface
    public static interface RelationshipFilter {
        public boolean test(long var1, long var3, long var5);

        default public RelationshipFilter and(RelationshipFilter after) {
            return (sourceNodeId, targetNodeId, relationshipId) -> this.test(sourceNodeId, targetNodeId, relationshipId) && after.test(sourceNodeId, targetNodeId, relationshipId);
        }
    }

    @FunctionalInterface
    public static interface TraversalPredicate {
        public TraversalState apply(long var1);
    }

    static enum TraversalState {
        EMIT_AND_STOP,
        EMIT_AND_CONTINUE,
        CONTINUE;

    }
}

