/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.dijkstra;

import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.paths.AllShortestPathsBaseConfig;
import org.neo4j.gds.paths.ShortestPathBaseConfig;
import org.neo4j.gds.paths.dijkstra.Dijkstra;

public abstract class DijkstraFactory<T extends AlgoBaseConfig & RelationshipWeightConfig>
extends GraphAlgorithmFactory<Dijkstra, T> {
    public MemoryEstimation memoryEstimation(T configuration) {
        return Dijkstra.memoryEstimation(false);
    }

    public String taskName() {
        return "Dijkstra";
    }

    public Task progressTask(Graph graph, T config) {
        return DijkstraFactory.dijkstraProgressTask(this.taskName(), graph);
    }

    public static Task dijkstraProgressTask(Graph graph) {
        return DijkstraFactory.dijkstraProgressTask("Dijkstra", graph);
    }

    @NotNull
    public static Task dijkstraProgressTask(String taskName, Graph graph) {
        return Tasks.leaf((String)taskName, (long)graph.relationshipCount());
    }

    public static class AllShortestPathsDijkstraFactory<T extends AllShortestPathsBaseConfig>
    extends DijkstraFactory<T> {
        public Dijkstra build(Graph graph, T configuration, ProgressTracker progressTracker) {
            return Dijkstra.singleSource(graph, configuration, Optional.empty(), progressTracker);
        }
    }

    public static class SourceTargetDijkstraFactory<T extends ShortestPathBaseConfig>
    extends DijkstraFactory<T> {
        public Dijkstra build(Graph graph, T configuration, ProgressTracker progressTracker) {
            return Dijkstra.sourceTarget(graph, configuration, Optional.empty(), progressTracker);
        }
    }
}

