/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.dijkstra;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.paths.PathResult;

public class DijkstraResult {
    private final Stream<PathResult> paths;
    private final Runnable closeStreamAction;
    private final AtomicBoolean consumptionTriggered;

    public DijkstraResult(Stream<PathResult> paths) {
        this(paths, () -> {});
    }

    public DijkstraResult(Stream<PathResult> paths, Runnable closeStreamAction) {
        this.paths = paths;
        this.closeStreamAction = closeStreamAction;
        this.consumptionTriggered = new AtomicBoolean(false);
    }

    public Optional<PathResult> findFirst() {
        Optional<PathResult> first = this.paths.findFirst();
        this.runConsumptionAction();
        return first;
    }

    public void forEachPath(Consumer<PathResult> resultConsumer) {
        this.paths.forEach(resultConsumer);
        this.runConsumptionAction();
    }

    public <T> Stream<T> mapPaths(Function<PathResult, T> fn) {
        return (Stream)this.paths.map(fn).onClose(this::runConsumptionAction);
    }

    public Set<PathResult> pathSet() {
        Set<PathResult> resultSet = this.paths.collect(Collectors.toSet());
        this.runConsumptionAction();
        return resultSet;
    }

    private void runConsumptionAction() {
        if (this.consumptionTriggered.compareAndSet(false, true)) {
            this.closeStreamAction.run();
        }
    }
}

